package com.ds.handler;

import com.ds.common.JDSException;
import com.ds.common.util.FileUtility;
import com.ds.common.util.StringUtility;
import com.ds.config.JDSUtil;
import com.ds.config.ResultModel;
import com.ds.server.httpproxy.core.*;
import com.ds.template.JDSFreemarkerResult;
import com.ds.vfs.FileInfo;
import com.ds.vfs.FileVersion;
import com.ds.vfs.VFSConstants;
import com.ds.vfs.ct.CtVfsFactory;
import com.ds.vfs.ct.CtVfsService;
import freemarker.template.TemplateException;

import java.io.*;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class DownLoadHandler extends AbstractHandler implements Handler {

    private static final long serialVersionUID = 1L;


    private static final Logger log = Logger.getLogger(DownLoadHandler.class.getName());
    public static final ConfigOption RULE_OPTION = new ConfigOption("rule", true, "Regular expression for matching URLs.");

    Pattern rule;

    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        rule = Pattern.compile(RULE_OPTION.getProperty(server, handlerName));
        return true;
    }

    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        String resource = request.getPath();
        boolean ruleMatches = rule.matcher(resource).matches();
        if (!ruleMatches) {
            return false;
        }
        InputStream stream = null;
        String path = request.getParameter("path").toString().trim();
        File file = new File(JDSUtil.getJdsRealPath() + path);
        if (file.exists()) {
            stream = new FileInputStream(file);
            String mimeType = Conts.getSuffixMap().get(file.getName().substring(file.getName().indexOf(".")));
            response.setMimeType("application/octet-stream");
            response.addHeader("Content-disposition", "filename=" + new String(file.getName().getBytes("utf-8"), "ISO8859-1"));
            response.addHeader("Content-Length", String.valueOf(file.length()));
            response.sendResponse(stream, Integer.valueOf(Long.toString(file.length())));
        } else {
            String personId = request.getParameter("personId");
            ResultModel<InputStream> userStatusInfo = new ResultModel<InputStream>();
            // 激活下载操作

            FileInfo fileInfo = null;
            FileVersion version = null;
            try {
                version = getVfsClient().getFileVersionByPath(path);
                if (path.indexOf(VFSConstants.URLVERSION) > -1) {
                    path = path.split(VFSConstants.URLVERSION)[0];
                }
                fileInfo = getVfsClient().getFileByPath(path);
                if (fileInfo != null) {
                    stream = version.getInputStream();
                }
            } catch (JDSException e) {
                e.printStackTrace();
            }
            if (stream != null) {
                String mimeType = Conts.getSuffixMap().get(fileInfo.getName().substring(fileInfo.getName().indexOf(".")));
                response.setMimeType("application/octet-stream");
                response.addHeader("Content-disposition", "filename=" + new String(fileInfo.getName().getBytes("utf-8"), "ISO8859-1"));
                JDSFreemarkerResult freemarkerResult = new JDSFreemarkerResult();
                if (fileInfo.getPath().endsWith(".js")) {
                    try {
                        Writer stringWriter = freemarkerResult.doExecute(version.getFileObject().getHash(), CtVfsFactory.getLocalCachePath());
                        response.setMimeType(mimeType);
                        String json=stringWriter.toString();
                        response.sendResponse(getInputStream(json, "utf-8"),-1);

                    } catch (TemplateException e) {
                        e.printStackTrace();
                    }
                } else {
                    response.addHeader("Content-Length", String.valueOf(version.getLength()));
                    response.sendResponse(stream, version.getLength().intValue());
                }
            }

        }


        return true;
    }

    public CtVfsService getVfsClient() {
        CtVfsService vfsClient = CtVfsFactory.getCtVfsService();
        return vfsClient;
    }

    private void creatPackage(String path) {
        path = formatFilePath(path);
        File pathFile = new File(FileUtility.getPath(path, File.separator.charAt(0)));
        if (pathFile != null && !pathFile.exists()) {
            pathFile.mkdirs();
        }
    }

    private String formatFilePath(String path) {
        if (!"/".equals(File.separator)) {
            path = StringUtility.replace(path, "/", File.separator);
        } else {
            path = StringUtility.replace(path, "\\", File.separator);
        }
        return path;
    }

    public static void main(String[] args) {
        System.out.println(System.currentTimeMillis() - 1000 * 60 * 60 * 7);
    }

}
