package com.ds.fdt.server.service;

import com.ds.common.database.dao.DAO;
import com.ds.common.database.dao.DAOCondition;
import com.ds.common.database.dao.DAOFactory;
import com.ds.common.database.dao.DBMap;
import com.ds.common.query.JoinOperator;
import com.ds.common.query.Operator;
import com.ds.common.util.StringUtility;
import com.ds.config.ErrorResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.web.util.PageUtil;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.Map;
import java.util.Set;

//@Controller
//@RequestMapping("/jds/fdt/dao/grid")
public class DAOGridService {


    //    @RequestMapping(method = RequestMethod.POST, value = "/{className}/Delete")
    public @ResponseBody
    ResultModel<Boolean> deleteDAO(@PathVariable String className, String pkvalues) {
        ResultModel<Boolean> result = new ResultModel<Boolean>();
        String[] pks = StringUtility.split(pkvalues, ";");
        try {
            DAOFactory<DBMap> factory = new DAOFactory<DBMap>("console", className);
            for (String pkVlaue : pks) {
                factory.getDAO().delete(pkVlaue);
            }

        } catch (Exception e) {
            result = new ErrorResultModel();
            ((ErrorResultModel) result).setErrdes(e.getMessage());
        }

        return result;
    }

    //    @RequestMapping(method = RequestMethod.POST, value = "/{className}/FindAll")
    public @ResponseBody
    ListResultModel<List<DBMap<String, Object>>> findDAO(@PathVariable String className) {


        ListResultModel<List<DBMap<String, Object>>> result = new ListResultModel<List<DBMap<String, Object>>>();

        try {
            DAOFactory<DBMap<String, Object>> factory = new DAOFactory<DBMap<String, Object>>("console", className);
            DAO dao = factory.getDAO();
            DAOCondition condition = dao.getMainCondition();

            List<DBMap<String, Object>> mapdaos = dao.find(condition);
            result = PageUtil.getDefaultPageList(mapdaos);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return result;
    }


    //    @RequestMapping(method = RequestMethod.POST, value = "/{className}/Find")
    public @ResponseBody
    ListResultModel<List<DBMap<String, Object>>> findDAO(@PathVariable String className, DBMap valueMap) {


        ListResultModel<List<DBMap<String, Object>>> result = new ListResultModel<List<DBMap<String, Object>>>();

        try {
            DAOFactory<DBMap<String, Object>> factory = new DAOFactory<DBMap<String, Object>>("console", className);
            DAO dao = factory.getDAO();
            DAOCondition condition = dao.getMainCondition();
            Set<Map.Entry<String, Object>> keySet = valueMap.entrySet();

            for (Map.Entry<String, Object> entry : keySet) {
                Object value = entry.getValue();
                String key = entry.getKey();
                if (value != null && !value.toString().equals("")) {
                    DAOCondition childCondition = dao.createCondition(key, Operator.LIKE, "%" + value + "%");
                    condition.addCondition(childCondition, JoinOperator.JOIN_AND);
                }

            }
            List<DBMap<String, Object>> mapdaos = dao.find(condition);
            result = PageUtil.getDefaultPageList(mapdaos);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return result;
    }

}
