package com.ds.fdt.server.service;

import com.ds.common.database.dao.DAOFactory;
import com.ds.common.database.dao.DBMap;
import com.ds.common.database.dao.TableMap;
import com.ds.config.ErrorResultModel;
import com.ds.config.ResultModel;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

public class DAOFromService {


    //@RequestMapping(method = RequestMethod.POST, value = "/{className}/New")
    public @ResponseBody
    ResultModel newDAO(@PathVariable String className) {
        ResultModel result = new ResultModel();
        try {
            DAOFactory<DBMap> factory = new DAOFactory<DBMap>("console", className);
            Map datamp = factory.getDAO().createBean();
            result.setData(datamp);
        } catch (Exception e) {
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }

        return result;
    }


    //@RequestMapping(method = RequestMethod.POST, value = "/{className}/Update")
    public @ResponseBody
    ResultModel<Boolean> updateDAO(@PathVariable String className, @RequestBody TableMap valueMap) {
        ResultModel<Boolean> result = new ResultModel<Boolean>();
        try {
            DAOFactory<DBMap> factory = new DAOFactory<DBMap>(valueMap.getConfigKey(), valueMap.getTableName());
            factory.getDAO().update(valueMap);
        } catch (Exception e) {
            result = new ErrorResultModel();
            ((ErrorResultModel) result).setErrdes(e.getMessage());
        }

        return result;
    }


    //@RequestMapping(method = RequestMethod.POST, value = "/{className}/Get")
    public @ResponseBody
    ResultModel getDAO(@PathVariable String className, String pkValue) {

        ResultModel result = new ResultModel();
        try {

            DAOFactory<DBMap> factory = new DAOFactory<DBMap>("console", className);
            DBMap dao = factory.getDAO().findByPrimaryKey(pkValue);
            result.setData(dao);
        } catch (Exception e) {
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }

        return result;
    }
}
