package com.ds.expression;

import com.ds.esb.config.manager.ServiceBean;
import com.ds.esd.custom.ESDField;

public class KeyStartBean {
    String str;
    String id;
    String expression;

    String lastStr;
    String desc;

    public KeyStartBean(String parentName, ESDField field) {
        this.id = field.getId();
        this.desc = parentName + "." + field.getName() + "(" + field.getCaption() + ")";
        this.expression = parentName + "." + field.getId();
        this.lastStr = field.getId();
    }

    public KeyStartBean(ServiceBean bean) {
        this.id = "$" + bean.getExpression();
        this.desc = "$" + bean.getId() + "(" + bean.getName() + ")";
        this.expression = "$" + bean.getExpression();
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStr() {
        return str;
    }

    public void setStr(String str) {
        this.str = str;
    }

    public String getExpression() {
        return expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getLastStr() {
        return lastStr;
    }

    public void setLastStr(String lastStr) {
        this.lastStr = lastStr;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
