package com.ds.editor.chrome.task;

import com.ds.common.JDSException;
import com.ds.config.UserBean;
import com.ds.editor.chrome.PageEditor;
import com.ds.editor.cmd.ESDChrome;
import com.ds.server.JDSServer;
import com.ds.server.httpproxy.ServerProxyFactory;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;

import java.net.URL;
import java.util.Collections;
import java.util.concurrent.Callable;

public class OpenURL implements Callable<PageEditor> {

    private final ChromeDriver chrome;
    private final URL url;
    private final String sessionid;

    public OpenURL(ChromeDriver chrome, URL url, String sessionid) {
        this.chrome = chrome;
        this.url = url;
        this.sessionid = sessionid;
    }

    @Override
    public PageEditor call() {

        String jsessionid = sessionid;
        if (jsessionid == null) {
            try {
                jsessionid = JDSServer.getInstance().getAdminUser().getSessionId();
            } catch (JDSException e) {
                e.printStackTrace();
            }
        }
        ChromeOptions options = new ChromeOptions();
        options.setExperimentalOption("useAutomationExtension", false);
        options.setExperimentalOption("excludeSwitches", Collections.singletonList("enable-automation"));
        String proxyUrl = UserBean.getInstance().getProxyHost() + ":" + ServerProxyFactory.getInstance().getProxyServer().getPort();
        options.addArguments("--proxy-server=" + proxyUrl);
        PageEditor pageEditor = new PageEditor(options, url, jsessionid);
        ESDChrome esdChrome = new ESDChrome(pageEditor);
        esdChrome.screenPage(url, 10000);

        return pageEditor;
    }
}
