package com.ds.editor.chrome;

import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;

public class CaptureImgUtil {

    public static File captureElement(ChromeDriver driver, By by) throws IOException {
        WebElement webElement = driver.findElement(by);
        File tmpFile = File.createTempFile("screenshot", ".png");
        byte[] imgbyte = driver.getScreenshotAs(OutputType.BYTES);
        return captureElement(imgbyte, webElement.getRect());
    }

    public static File captureElement(byte[] bytes, Rectangle rectangle) throws IOException {
        File tmpFile = File.createTempFile("screenshot", ".png");
        BufferedImage img = ImageIO.read(new ByteArrayInputStream(bytes));
        int width = rectangle.getWidth();
        int height = rectangle.getHeight();
        //获取指定元素的坐标
        int x = rectangle.getX();
        int y = rectangle.getY();
        //从元素左上角坐标开始，按照元素的高宽对img进行裁剪为符合需要的图片
        BufferedImage dest = img.getSubimage(x, y, width, height);
        ImageIO.write(dest, "png", tmpFile);

        return tmpFile;
    }

    public static File captureElement(File screenshot, Rectangle rectangle) {
        try {
            BufferedImage img = ImageIO.read(screenshot);
            int width = Double.valueOf(rectangle.getWidth()).intValue();
            int height = Double.valueOf(rectangle.getHeight()).intValue();
            //获取指定元素的坐标
            int x = Double.valueOf(rectangle.getX()).intValue();
            int y = Double.valueOf(rectangle.getY()).intValue();
            //从元素左上角坐标开始，按照元素的高宽对img进行裁剪为符合需要的图片
            BufferedImage dest = img.getSubimage(x, y, width, height);
            ImageIO.write(dest, "png", screenshot);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return screenshot;
    }


}