

package com.ds.editor;

import com.ds.PathUtil;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;

public class ESDSplash extends JWindow {

    private JProgressBar progress;

    private class UpdateStatus implements Runnable {

        public UpdateStatus(String status, int pc) {
            message = status;
            value = pc;
        }

        public void run() {
            progress.setValue(value);
            progress.setString(message);
        }

        private String message;

        private int value;
    }

    private class CloseSplashScreen implements Runnable {

        public void run() {
            setVisible(false);
            dispose();
        }
    }

    public ESDSplash(Icon coolPicture, String initialMessage, String title) {
        // Create a JPanel so we can use a BevelBorder
        JPanel panelForBorder = new JPanel(new BorderLayout());
        panelForBorder.setBackground(Color.white);
        panelForBorder.setLayout(new BorderLayout());
        panelForBorder.add(new JLabel(coolPicture), BorderLayout.CENTER);
        if (title != null)
            panelForBorder.add(new JLabel(title, JLabel.CENTER),
                    BorderLayout.NORTH);

        progress = new JProgressBar(0, 100);
        progress.setStringPainted(true);
        progress.setString(initialMessage);

        panelForBorder.add(progress, BorderLayout.SOUTH);
        panelForBorder.setBorder(new BevelBorder(BevelBorder.RAISED));

        getContentPane().add(panelForBorder);
    }

    /**
     * Close the splash screen and free any resources associated with it. This
     * method is thread safe and can be called from any thread.
     */
    public void close() {
        if (isVisible()) {
            SwingUtilities.invokeLater(new CloseSplashScreen());
        }
    }

    /**
     * Show or hide the splash screen.
     *
     * @param show True to display the splash screen
     */
    public void setVisible(boolean show) {
        if (show) {
            pack();

            // Plonk it on center of screen
            Dimension WindowSize = getSize(), ScreenSize = Toolkit
                    .getDefaultToolkit().getScreenSize();
            setBounds((ScreenSize.width - WindowSize.width) / 2,
                    (ScreenSize.height - WindowSize.height) / 2,
                    WindowSize.width, WindowSize.height);
        }
        super.setVisible(show);
    }

    /**
     * Updates the status bar. This method is thread safe and can be called from
     * any thread.
     *
     * @param message The message to display
     * @param percent The percentage towards completion
     */
    public void showStatus(String message, int percent) {
        if (isVisible()) {
            String text = PathUtil.getUtfCode(message);
            SwingUtilities.invokeLater(new UpdateStatus(text, percent));
        }
    }

}
