/**
 * $RCSfile: KTreePathSelection.java,v $
 * $Revision: 1.1 $
 * $Date: 2013/05/28 12:16:42 $
 *
 * Copyright (C) 2003 spk, Inc. All rights reserved.
 *
 * This software is the proprietary information of spk, Inc.
 * Use is subject to license terms.
 */
package com.ds.common.swing.tree;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;

import javax.swing.tree.TreePath;

/**
* This represents a TreePath (a node in a JTree) that can be transferred between a drag source and a drop target.
*/
public class KTreePathSelection implements Transferable {
    // The type of DnD object being dragged...
    public static final DataFlavor TREEPATH_FLAVOR = new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType, "TreePath");

    private TreePath _path;

    private DataFlavor[] _flavors = { TREEPATH_FLAVOR };

    /**
    * Constructs a transferrable tree path object for the specified path.
    */
    public KTreePathSelection(TreePath path) {
        _path = path;
    }

    // Transferable interface methods...
    public DataFlavor[] getTransferDataFlavors() {
        return _flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return java.util.Arrays.asList(_flavors).contains(flavor);
    }

    public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.isMimeTypeEqual(TREEPATH_FLAVOR.getMimeType())) // DataFlavor.javaJVMLocalObjectMimeType))
            return _path;
        else
            throw new UnsupportedFlavorException(flavor);
    }
}
