package com.ds.common.swing.tree;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import com.ds.config.MenuCfg;
import com.ds.jds.core.esb.util.ActionContext;

public class JDSTreeListener extends MouseAdapter implements TreeSelectionListener {

    private JTree tree;

    public JDSTreeListener(JTree tree) {
	this.tree = tree;
    }

    public void mousePressed(MouseEvent e) {
	TreePath path = tree.getPathForLocation(e.getX(), e.getY());
	if (path == null) {
	    return;
	}
	tree.setSelectionPath(path);
	DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode) tree.getSelectionPath().getLastPathComponent();
	Object obj = treeNode.getUserObject();
	MenuCfg menuCfg = (MenuCfg) obj;
	if (e.getButton() == 3) {
	    if (menuCfg.getRightMenuUrl() != null) {
		// JPopupMenu blockPopMenu=JDSMenuUtil.getPopMenuByPath(menuCfg.getRightMenuUrl());
		// blockPopMenu.show(tree, e.getX(), e.getY());
	    }
	} else {
	    if (menuCfg.getHandler() != null) {

		ActionContext.getContext().getValueStack().findValue(menuCfg.getHandler());
	    }
	}

    }

    public void valueChanged(TreeSelectionEvent e) {
	if (e.getNewLeadSelectionPath() != null) {
	    DefaultMutableTreeNode jdsTreeNode = (DefaultMutableTreeNode) e.getNewLeadSelectionPath().getLastPathComponent();
	    Object obj = jdsTreeNode.getUserObject();
	    MenuCfg menuCfg = (MenuCfg) obj;
	    if (menuCfg.getSelectedScript() != null) {

		ActionContext.getContext().getValueStack().findValue(menuCfg.getSelectedScript());
	    }

	}

    }
}
