package com.ds.common.swing.tree;


import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

import com.ds.config.JDSUtil;
import com.ds.config.MenuCfg;

/**
 */
public class JDSTreeCellRenderer extends DefaultTreeCellRenderer
{
	
	/**
	 * ID
	 */
	private static final long	serialVersionUID	= 1L;

	
	@Override
	public Component getTreeCellRendererComponent(JTree tree, Object value,
			boolean sel, boolean expanded, boolean leaf, int row,
			boolean hasFocus)
	{

		
		super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf,
				row, hasFocus);

		setText(value.toString());
		
		if (sel)
		{
			setForeground(getTextSelectionColor());
		}
		else
		{
			setForeground(getTextNonSelectionColor());
		}
		
		
		DefaultMutableTreeNode node = (DefaultMutableTreeNode) value;
		Object obj=node.getUserObject();
		
		try{
			if (obj instanceof MenuCfg) {		
				MenuCfg menuCfg=(MenuCfg) obj;
                ImageIcon imageIcon=getIcon(menuCfg.getIcon());
				this.setIcon(imageIcon);
				
			}
			
		}catch(Exception e){
			
		}
		
	
		
	

		return this;
	}
	
	
	private ImageIcon getIcon(String iconUrl){
		ImageIcon imageIcon=null;
		if (iconUrl!=null && !iconUrl.equals("")){
			String icon=iconUrl;
			if (!icon.trim().startsWith("http://")){
				try {
					icon= JDSUtil.getJdsRealPath()+icon;
				} catch (MalformedURLException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			URL imgUrl=null;
	   		try {
	   			imgUrl = new URL(icon);
	   		} catch (Exception e) {
	   			e.printStackTrace();
	   		}
	   	   imageIcon= new ImageIcon(imgUrl);
	   	   imageIcon=zoomIcon(imageIcon,new Dimension(20,20));
	   	   
		}
		return imageIcon;
	}
	
	private ImageIcon  zoomIcon(ImageIcon icon, Dimension size){
		if (icon!=null){
			try {
			    Image menuImage=icon.getImage();
			    menuImage=menuImage.getScaledInstance(size.width, size.height, 1);
			    icon.setImage(menuImage);
			} catch (Exception e) {
			}
		}
		return  icon;
	}
	
}
