package com.ds.common.swing.tree;

import java.awt.BorderLayout;

import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;

import com.ds.config.MenuCfg;

public class JDSTree extends BaseTreePanel  {

	private DefaultMutableTreeNode root;
	private MenuCfg menuCfg;
	
	public JDSTree(DefaultMutableTreeNode root){
	    this.menuCfg=(MenuCfg)root.getUserObject();
		treePanel.setModel(new JDSTreeModel(root));
		treePanel.setRootVisible(false);
		treePanel.setShowsRootHandles(true);
		JScrollPane jsPanel = new JScrollPane();
		jsPanel.setViewportView(treePanel);
		setLayout(new BorderLayout());
		add(BorderLayout.CENTER, jsPanel);
		setTitle(menuCfg.getText(), true);	
		this.setName(menuCfg.getId());
		
	}
	
	
	
}
