package com.ds.common.swing.tree;

import java.awt.Color;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

import com.ds.bpm.bpd.BPDConfig;

public class BaseTreePanel extends JPanel{


	public JTree treePanel;
	
	
	public BaseTreePanel(){
		this.treePanel = new JTree();
	}
	

	public JTree getTreePanel() {
		return treePanel;
	}

	public void setTreePanel(JTree treePanel) {
		this.treePanel = treePanel;
	}

	
	/**
	
	 * @param title
	 * @param hasBorder
	 */
	public void setTitle(String title, boolean hasBorder) {
		int emptyBorderHSize = 5;
		int emptyBorderVSize = 5;
		Border emptyb = BorderFactory.createEmptyBorder(emptyBorderVSize,
				emptyBorderHSize, emptyBorderVSize, emptyBorderHSize);
		Border inb = BorderFactory.createEmptyBorder(0, 0, 0, 0);
		if (hasBorder) {
			inb = BorderFactory.createMatteBorder(1, 1, 1, 1, Color.darkGray);
			inb = BorderFactory.createTitledBorder(inb, title,
					TitledBorder.DEFAULT_JUSTIFICATION,
					TitledBorder.DEFAULT_POSITION, BPDConfig.getInstance()
							.getFont());
		} else {
			emptyb = BorderFactory.createTitledBorder(emptyb, title,
					TitledBorder.DEFAULT_JUSTIFICATION,
					TitledBorder.DEFAULT_POSITION, BPDConfig.getInstance()
							.getFont());
		}
		setBorder(BorderFactory.createCompoundBorder(emptyb, inb));
	}

}
