package com.ds.common.swing.table;

import java.util.Collection;

/**
 * TableViewModelEvent is used to notify listeners that a table view model.
 *
  * @author St閜hane Brunner, Last modified by: $Author: wenzhangli $ 
* @version $Revision: 1.1 $ $Date: 2013/05/28 12:16:32 $.
 * Revision history:
 * $Log: TableViewModelEvent.java,v $
 * Revision 1.1  2013/05/28 12:16:32  wenzhangli
 * v5.0
 * Committed on the Free edition of March Hare Software CVSNT Server.
 * Upgrade to CVS Suite for more features and support:
 * http://march-hare.com/cvsnt/
 *
 * Revision 1.1  2012/06/07 07:42:42  lwz
 * *** empty log message ***
 *
 * Revision 1.1  2011/06/09 14:42:35  administrator
 * *** empty log message ***
 *
 * Revision 1.2  2010/04/20 07:08:45  liwengzhang
 * *** empty log message ***
 *
 * Revision 1.1  2009/10/20 07:20:17  administrator
 * v3.0
 *
 * Revision 1.1  2009/08/04 09:45:15  administrator
 * *** empty log message ***
 *
 * Revision 1.1  2009/03/20 10:54:10  administrator
 * *** empty log message ***
 *
 * Revision 1.1  2008/12/24 07:55:03  administrator
 * *** empty log message ***
 *
 * Revision 1.1  2003/12/26 03:38:52  andy
 * no message
 *
 * Revision 1.7  2003/06/06 06:31:32  stbrunner
 * Change description
 *
 * @see javas.swing.event.TableModelEvent
 */
public class TableViewModelEvent extends java.util.EventObject {
  /**
   * Identifies the addtion of new rows or columns.
   */
  public static final int INSERT = 1;
  /**
   * Identifies a change to existing data.
   */
  public static final int UPDATE = 0;
  /**
   * Identifies the removal of rows or columns.
   */
  public static final int DELETE = -1;

  /**
   * Identifies the header row.
   */
  public static final int HEADER_ROW = -1;

  /** the type */
  protected int mType;
  /** the row object */
  protected Collection mRowObjects;
  /** the colimn index */
  protected int mColumn;

  //
  // Constructors
  //

  /**
   * Construct with source model.
   * @param pSource the model
   */
  public TableViewModelEvent(TableViewModel pSource) {
    // Use Integer.MAX_VALUE instead of getRowCount() in case rows were deleted.
    this(pSource, null, UPDATE);
  }

  /**
   * Construct with source model and row Object.
   *
   * @param pSource the model
   * @param pRowObject the row Object
   */
  public TableViewModelEvent(TableViewModel pSource, Object pRowObject) {
    this(pSource, java.util.Arrays.asList(new Object[] {pRowObject}), UPDATE);
  }

  /**
   * Construct with source model, row Object and type.
   *
   * @param pSource the model
   * @param pRowObject the row Object
   * @param pType the type (INSERT, DELETE or UPDATE)
   */
  public TableViewModelEvent(TableViewModel pSource, Object pRowObject, int pType) {
    this(pSource, java.util.Arrays.asList(new Object[] {pRowObject}), pType);
  }

  /**
   * Construct with source model and row Objects.
   *
   * @param pSource the model
   * @param pRowObjects the rows Objects
   */
  public TableViewModelEvent(TableViewModel pSource, Collection pRowObjects) {
    this(pSource, pRowObjects, UPDATE);
  }

  /**
   * Construct with source model, rows Objects and type.
   *
   * @param pSource the model
   * @param pRowObjects the rows Objects
   * @param pType the type (INSERT, DELETE or UPDATE)
   */
  public TableViewModelEvent(TableViewModel pSource, Collection pRowObjects, int pType) {
    super(pSource);
    this.mRowObjects = pRowObjects;
    this.mType = pType;
  }

  //
  // Querying Methods
  //

  /**
   * Returns a collection of row Object.
   *
   * @return the rows
   */
  public Collection getRowObjects() {
    return mRowObjects;
  }

  /**
   * Returns the type of event - one of: INSERT, UPDATE and DELETE.
   *
   * @return the type
   */
  public int getType() {
    return mType;
  }
}
