package com.ds.common.swing.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * This abstract class provides default implementations the <code>TableViewModel</code> interface.
 *
 * @author St閜hane Brunner, Last modified by: $Author: wenzhangli $ 
 * @version $Revision: 1.1 $ $Date: 2013/05/28 12:16:32 $.
 * Revision history:
 * $Log: DefaultTableViewModel.java,v $
 * Revision 1.1  2013/05/28 12:16:32  wenzhangli
 * v5.0
 * Committed on the Free edition of March Hare Software CVSNT Server.
 * Upgrade to CVS Suite for more features and support:
 * http://march-hare.com/cvsnt/
 *
 * Revision 1.1  2012/06/07 07:42:42  lwz
 * *** empty log message ***
 *
 * Revision 1.1  2011/06/09 14:42:37  administrator
 * *** empty log message ***
 *
 * Revision 1.2  2010/04/20 07:08:44  liwengzhang
 * *** empty log message ***
 *
 * Revision 1.1  2009/10/20 07:20:17  administrator
 * v3.0
 *
 * Revision 1.1  2009/08/04 09:45:15  administrator
 * *** empty log message ***
 *
 * Revision 1.1  2009/03/20 10:54:10  administrator
 * *** empty log message ***
 *
 * Revision 1.1  2008/12/24 07:55:04  administrator
 * *** empty log message ***
 *
 * Revision 1.1  2003/12/26 03:38:52  andy
 * no message
 *
 * Revision 1.7  2003/06/06 06:31:32  stbrunner
 * Change description
 *
 */
public class DefaultTableViewModel extends AbstractTableViewModel {

  private List mContent = new ArrayList();
  private TableViewColumn[] mColumn;

  /**
   * Construct.
   * @see java.lang.Object#Object()
   */
  public DefaultTableViewModel() {
    this((Collection)null);
  }

  /**
   * Construct.
   * @param pColumns all the collumns
   */
  public DefaultTableViewModel(TableViewColumn[] pColumns) {
    this(pColumns, null);
  }

  /**
   * Construct.
   * @param pContent the rows
   */
  public DefaultTableViewModel(Collection pContent) {
    this(null, pContent);
  }

  /**
   * Construct.
   * @param pColumns all the collumns
   * @param pContent the rows
   */
  public DefaultTableViewModel(TableViewColumn[] pColumns, Collection pContent) {
    if (pContent != null) {
      mContent.addAll(pContent);
    }
    mColumn = pColumns == null ? new TableViewColumn[]{new DefaultTableViewColumn("Name")} : pColumns;
  }

  /**
   * Gets the numur o
   * Returns the number of rows.
   * @return the number of rows
   * @see sbrunner.gui.tableView.TableViewModel#getRowCount()
   */
  public int getRowCount() {
    return mContent.size();
  }

  /**
   * Returns the Object represent the row.
   * @param pRowIndex  the row whose value is to be queried
   * @return the Object represent the row
   * @see sbrunner.gui.tableView.TableViewModel#getRowObject(int)
   */
  public Object getRowObject(int pRowIndex) {
    return mContent.get(pRowIndex);
  }

  /**
   * Gets the columns
   * @return TableViewColumn[] the columns
   * @see sbrunner.gui.tableView.TableViewModel#getColumns()
   */
  public TableViewColumn[] getColumns() {
    return mColumn;
  }

  /**
   * Adds a row
   * @param pRowObject the new row
   */
  public void addRow(Object pRowObject) {
    mContent.add(pRowObject);
    fireTableRowInserted(pRowObject);
  }

  /**
   * Adds some rows
   * @param pRowObjects the rows object
   */
  public void addRows(Collection pRowObjects) {
    mContent.add(pRowObjects);
    fireTableRowsInserted(pRowObjects);
  }

  /**
   * Removes a row.
   * @param pRowObject the row to remove
   */
  public void removeRow(Object pRowObject) {
    mContent.remove(pRowObject);
    fireTableRowDeleted(pRowObject);
  }

  /** 
   * Removes some rows.
   * @param pRowObjects The rows to removes
   */
  public void removeRows(Collection pRowObjects) {
    mContent.removeAll(pRowObjects);
    fireTableRowsDeleted(pRowObjects);
  }

  /**
   * Updates a row.
   * @param pRowObject the row to update
   */
  public void updateRow(Object pRowObject) {
    fireTableRowUpdated(pRowObject);
  }

  /**
   * Updates some rows.
   * @param pRowObjects the rows to update
   */
  public void updateRows(Collection pRowObjects) {
    fireTableRowsUpdated(pRowObjects);
  }

  /**
   * Update row by a new object.
   * @param pOldRowObject the old row object
   * @param pNewRowObject the new row object
   */
  public void updateRow(Object pOldRowObject, Object pNewRowObject) {
    removeRow(pOldRowObject);
    addRow(pNewRowObject);
  }
}
