package com.ds.common.swing.table;

import java.io.Serializable;

import javax.swing.event.EventListenerList;

/**
 * This abstract class provides default implementations for most of
 * the methods in the <code>TableViewColumn</code> interface.
 *
 * @author St閜hane Brunner, Last modified by: $Author: wenzhangli $ 
 * @version $Revision: 1.1 $ $Date: 2013/05/28 12:16:32 $.
 * Revision history:
 * $Log: AbstractTableViewColumn.java,v $
 * Revision 1.1  2013/05/28 12:16:32  wenzhangli
 * v5.0
 * Committed on the Free edition of March Hare Software CVSNT Server.
 * Upgrade to CVS Suite for more features and support:
 * http://march-hare.com/cvsnt/
 *
 * Revision 1.1  2012/06/07 07:42:42  lwz
 * *** empty log message ***
 *
 * Revision 1.1  2011/06/09 14:42:36  administrator
 * *** empty log message ***
 *
 * Revision 1.2  2010/04/20 07:08:45  liwengzhang
 * *** empty log message ***
 *
 * Revision 1.1  2009/10/20 07:20:17  administrator
 * v3.0
 *
 * Revision 1.1  2009/08/04 09:45:16  administrator
 * *** empty log message ***
 *
 * Revision 1.1  2009/03/20 10:54:11  administrator
 * *** empty log message ***
 *
 * Revision 1.1  2008/12/24 07:55:05  administrator
 * *** empty log message ***
 *
 * Revision 1.1  2003/12/26 03:38:52  andy
 * no message
 *
 * Revision 1.7  2003/06/06 06:31:32  stbrunner
 * Change description
 *
 */
public abstract class AbstractTableViewColumn implements TableViewColumn, Serializable {

  //
  // Instance Variables
  //

  /**
   * List of listeners
   */
  protected EventListenerList mListenerList = new EventListenerList();

  //
  // Default Implementation of the Interface
  //

  /**
   * Returns a default name for the column using spreadsheet conventions:
   * A, B, C, ... Z, AA, AB, etc.  If <code>column</code> cannot be found,
   * returns an empty string.
   *
   * @param pColumn  the column being queried
   * @return a string containing the default name of <code>column</code>
   */
  public String getColumnName(int pColumn) {
    String result = "";
    for (; pColumn >= 0; pColumn = pColumn / 26 - 1) {
      result = (char) ((char) (pColumn % 26) + 'A') + result;
    }
    return result;
  }

  /**
   * Returns <code>Object.class</code> regardless of <code>columnIndex</code>.
   *
   * @return the Object.class
   */
  public Class getColumnClass() {
    return Object.class;
  }

  /**
   * Returns false.  This is the default implementation for all cells.
   *
   * @param  pRowObject  the row being queried
   * @return false
   */
  public boolean isCellEditable(Object pRowObject) {
    return false;
  }

  /**
   * This empty implementation is provided so users don't have to implement
   * this method if their data model is not editable.
   *
   * @param  pValue   value to assign to cell
   * @param  pRowIndex   row of cell
   * @param  pColumnIndex  column of cell
   */
  public void setValueAt(Object pValue, int pRowIndex, int pColumnIndex) {
  }

  /**
   * The sortable status.
   *
   * @return true
   */
  public boolean isSortable() {
    return true;
  }

  /**
   * The searchable status.
   *
   * @return true
   */
  public boolean isSearchable() {
    return true;
  }
}
