/**
 * $RCSfile: Task.java,v $
 * $Revision: 1.1 $
 * $Date: 2013/05/28 12:16:39 $
 *
 * Copyright (C) 2003 spk, Inc. All rights reserved.
 *
 * This software is the proprietary information of spk, Inc.
 * Use is subject to license terms.
 */
package com.ds.common.swing.progress;

/**
 * <p>Title: 常用代码打包</p>
 * <p>Description: 
 * This is the parent class of what performs a time consuming task. It can also
 *  interract with ProgressDialog to monitor the process of the task.
 * <p>Copyright: Copyright (c) 2006</p>
 * <p>Company: www.justdos.net</p>
 * @author wenzhang li
 * @version 1.0
 */
public abstract class Task {

  //----------------------------------------------------------------------------
  // Public methods
  //----------------------------------------------------------------------------

  /**
   *  Sample:<p>
   *
   *  <code>
   * public void go() { <br>
   *  final SwingWorker worker = new SwingWorker() { <br>
   *  public Object construct() { <br>
   *  // time consuming task here... <br>
   *  <br>
   *  // return a Object class that SwingWorker needed <br>
   *  return new Object(); <br>
   *  }}}</code></p> This method is invoked by the user when the task wanna to
   *  start.
   */
  public abstract void go();

  /**
   *  Invoked by ProgressDialog when the task is canceled or an error occured.
   */
  public abstract void cancel();

  /**
   *  Invoked by ProgressDialog when the task is completed.
   */
  public abstract void complete();

  /**
   *  Stop this task. If you wanna stop the task and regard it as completed,
   *  invoke it.
   */
  public void stop() {
    current = lengthOfTask;
  }

  /**
   *  If you catch an Exception or have other reason to stop the task and not
   *  regard it as completed, pass true to this method.
   *
   *@param  hasError  The new hasError value
   */
  public void setHasError( boolean hasError ) {
    this.hasError = hasError;
  }

  /**
   *  ProgressDialog will timely check the return value of this method to adjust
   *  whether an error accured. If so, ProgressDialog will invoke the task's
   *  cancel method and display an error message according the getMessage()'s
   *  return value.
   *
   *@return    The hasError value
   */
  public boolean getHasError() {
    return hasError;
  }

  /**
   *  ProgressDialog use this method to adjust whether the task has done.
   *
   *@return    Description of the Return Value
   */
  public boolean done() {
    if ( current >= lengthOfTask )
    {
      return true;
    }
    else
    {
      return false;
    }
  }

  /**
   *  Gets the lengthOfTask attribute of the Task object
   *
   *@return    The lengthOfTask value
   */
  public int getLengthOfTask() {
    return lengthOfTask;
  }

  /**
   *  Sets the lengthOfTask attribute of the Task object
   *
   *@param  lengthOfTask  The new lengthOfTask value
   */
  public void setLengthOfTask( int lengthOfTask ) {
    this.lengthOfTask = lengthOfTask;
  }

  /**
   *  Gets the current attribute of the Task object
   *
   *@return    The current value
   */
  public int getCurrent() {
    return current;
  }

  /**
   *  Sets the current attribute of the Task object
   *
   *@param  current  The new current value
   */
  public void setCurrent( int current ) {
    this.current = current;
  }

  /**
   *  Gets the message attribute of the Task object
   *
   *@return    The message value
   */
  public String getMessage() {
    return statMessage;
  }

  /**
   *  Sets the message attribute of the Task object
   *
   *@param  statMessage  The new message value
   */
  public void setMessage( String statMessage ) {
    this.statMessage = statMessage;
  }

  //----------------------------------------------------------------------------
  // Private fields
  //----------------------------------------------------------------------------

  private int lengthOfTask = 0;
  private int current = 0;
  private String statMessage;
  private boolean hasError = false;
}
