/**
 * $RCSfile: Images.java,v $
 * $Revision: 1.1 $
 * $Date: 2014/07/08 00:25:55 $
 *
 * Copyright (C) 2003 spk, Inc. All rights reserved.
 *
 * This software is the proprietary information of spk, Inc.
 * Use is subject to license terms.
 */
package com.ds.common.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;

import javax.swing.GrayFilter;

/**
 * <p>Title: ���ô�����</p>
 * <p>Description: Get Image object.</p>
 * <p>Copyright: Copyright (c) 2006</p>
 * <p>Company: www.justdos.net</p>
 * @author wenzhang li
 * @version 1.0
 */
public final class Images {

    /**
     *  Description of the Method
     *
     *@param  image  Description of the Parameter
     */
    public static synchronized void waitForImage(Image image) {
        if (cachedImage.contains(image)) {
            return;
        }
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        } catch (InterruptedException interruptedexception) {}
        mediaTracker.removeImage(image);
        cachedImage.add(image);
    }

    /**
     *  Gets the image attribute of the Images class
     *
     *@param  url   Description of the Parameter
     *@param  flag  if wait for the image
     *@return       The image value
     */
    public static synchronized Image getImage(URL url, boolean flag) {
        Image image = (Image)urlImage.get(url);
        if (image == null) {
            image = Toolkit.getDefaultToolkit().createImage(url);
            if (image == null) {
                image = defaultImage;
            }
            urlImage.put(url, image);
        }
        if (flag) {
            waitForImage(image);
        }
        return image;
    }

    /**
     *  Gets the image attribute of the Images class
     *
     *@param  url  Description of the Parameter
     *@return      The image value
     */
    public static Image getImage(URL url) {
        return getImage(url, true);
    }

    /**
     *  Gets the image attribute of the Images class
     *
     *@param  class1  Description of the Parameter
     *@param  s       Description of the Parameter
     *@param  flag    Description of the Parameter
     *@return         The image value
     */
    public static Image getImage(Class class1, String s, boolean flag) {
        URL url = ResourceLocator.getResource(class1, s);
        return ((Image) (url != null ? getImage(url, flag) : defaultImage));
    }

    /**
     *  Gets the image attribute of the Images class
     *
     *@param  class1  Description of the Parameter
     *@param  s       Description of the Parameter
     *@return         The image value
     */
    public static Image getImage(Class class1, String s) {
        return getImage(class1, s, true);
    }

    /**
     *  Gets the disabledImage attribute of the Images class
     *
     *@param  image  Description of the Parameter
     *@return        The disabledImage value
     */
    public static synchronized Image getDisabledImage(Image image) {
        if (image == null) {
            return null;
        }
        Image image1 = (Image)cachedDisabledImage.get(image);
        if (image1 == null) {
            image1 = GrayFilter.createDisabledImage(image);
            waitForImage(image1);
            cachedDisabledImage.put(image, image1);
        }
        return image1;
    }

    private static HashMap cachedDisabledImage = new HashMap();
    private final static HashSet cachedImage = new HashSet();
    private final static HashMap urlImage = new HashMap();
    private final static MediaTracker mediaTracker = new MediaTracker(new MediaTrackerComponent());
    private final static int g = 16;
    private final static BufferedImage defaultImage = new BufferedImage(g, g, 1);
    // h

    static {
        java.awt.Graphics2D graphics2d = defaultImage.createGraphics();
        graphics2d.setColor(Color.red);
        graphics2d.fillRect(0, 0, g, g);
        cachedImage.add(defaultImage);
    }

    /**
     *  Description of the Class
     *
     *@author     Administrator
     *@created    2003��2��22��
     */
    static class MediaTrackerComponent extends Component {}

}
