package com.ds.bpm.bpd.xml.panels.tablesorting;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.Vector;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

import com.ds.bpm.bpd.xml.NewXMLCollection;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.NewXMLTablePanel;

public class SortingTable extends JTable {

   protected int sortedColIndex = -1;
   protected boolean ascending = true;

   NewXMLTablePanel owner;

   public SortingTable(NewXMLTablePanel p,Vector data, Vector names) {
      super(new SortingTableModel((NewXMLCollection)p.getOwner(),data, names));
      this.owner=p;

      JTableHeader h = getTableHeader();
      h.setDefaultRenderer(new SHRenderer());
      MouseListener ml=new MouseAdapter () {
         public void mouseReleased(MouseEvent event) {
            performSorting(event);
         }
      };

      h.addMouseListener(ml);
   }

   public int getSortedColumnIndex() {
      return sortedColIndex;
   }

   public boolean isSortedColumnAscending() {
      return ascending;
   }


   public void performSorting (MouseEvent event) {
      if(owner.getOwner().isReadOnly() && ((NewXMLCollection)owner.getOwner()).getOwner().isReadOnly()) return;
      if (event==null && sortedColIndex==-1) return;

      TableColumnModel colModel = getColumnModel();
      int index = sortedColIndex;
      if (event!=null) {
         index = colModel.getColumnIndexAtX(event.getX());
      }
      int modelIndex = colModel.getColumn(index).getModelIndex();

      SortingTableModel model = (SortingTableModel)getModel();

      Object selEl=null;
      int sr=getSelectedRow();
      if (sr>=0) {
         selEl=model.getValueAt(sr,0);
      }

      if (sortedColIndex == index && event!=null) {
         ascending = !ascending;
      }
      sortedColIndex = index;

      model.sortByColumn(modelIndex, ascending);
      NewXMLCollection c=(NewXMLCollection)owner.getOwner();
      int cs=c.size();
      if (cs>0) {
         c.toCollection().clear();
         for (int i=0; i<cs; i++) {
            Object el=model.getValueAt(i,0);
            c.toCollection().add(el);
         }
         ((XMLElementDialog)owner.getDialog()).notifyListeners((XMLElement)model.getValueAt(0,0)); // this is dirty hack
      }

      if (selEl!=null) {
         try {
            owner.setSelectedElement(selEl);
         } catch (Exception ex) {}
      }
      update(getGraphics());
      getTableHeader().update(getTableHeader().getGraphics());
   }

   static class SHRenderer extends DefaultTableCellRenderer {

      static Icon NONSORTED = null;
      static Icon ASCENDING = null;
      static Icon DESCENDING = null;

      static {
         URL url = XMLUtil.getResource("ASCENDINGImage");
         if ( url != null ) {
            ASCENDING = new ImageIcon( url );
         }
         url = XMLUtil.getResource("DESCENDINGImage");
         if ( url != null ) {
            DESCENDING = new ImageIcon( url );
         }
      }

      public SHRenderer() {
         setHorizontalTextPosition(LEFT);
         setHorizontalAlignment(CENTER);
      }

      public Component getTableCellRendererComponent(JTable table,
                                                     Object value,
                                                     boolean isSelected,
                                                     boolean hasFocus,
                                                     int row,
                                                     int col) {
         int index = -1;
         boolean ascending = true;
         SortingTable sortTable = (SortingTable)table;
         index = sortTable.getSortedColumnIndex();
         ascending = sortTable.isSortedColumnAscending();

         if (table != null) {
            JTableHeader header = table.getTableHeader();
            if (header != null) {
               setForeground(header.getForeground());
               setBackground(header.getBackground());
               setFont(header.getFont());
            }
         }

         Icon icon = null;
         if (ascending) {
            icon=ASCENDING;
         } else {
            icon=DESCENDING;
         }

         if (col==index) {
            setIcon(icon);
         } else {
            setIcon(NONSORTED);
         }

         if (value==null) {
            setText("");
         } else {
            setText(value.toString());
         }

         setBorder(UIManager.getBorder("TableHeader.cellBorder"));
         return this;
      }
   }

}

