/*
 * Created on 2006-4-1
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.panels.formula.org;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.misc.OrgTree;
import com.ds.bpm.bpd.misc.OrgTreeNode;
import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.common.JDSException;
import com.ds.org.Org;
import com.ds.org.OrgManager;
import com.ds.org.Person;
import com.ds.org.PersonNotFoundException;
import com.ds.server.JDSServer;
import com.ds.server.OrgManagerFactory;
import com.ds.server.SubSystem;

import javax.swing.*;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreePath;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 选择单个人员的面板类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-4-1 15:44:56
 * @version 1.0
 */
public class XMLPersonPanel extends XMLPanel {

    private static Dimension minimalDimension = new Dimension(120, 100);

    private static Dimension listDimension = new Dimension(120, 160);

    private List elements = new ArrayList();

    private int selectionMode;

    // 可选List
    private JList allPersonList = new JList();

    // 已选List
    private JList choosenList = new JList();

    // 构造器----显示原有信息
    public XMLPersonPanel(XMLElement myOwner, String title, boolean hasBorder, boolean minDimension, int selectionMode) {

	super(myOwner, 2, title, XMLPanel.BOX_LAYOUT, false, hasBorder);
	this.selectionMode = selectionMode;

	// 调用Org接口得到服务器的组织机构
	JPanel jPanel = new JPanel();
	jPanel.setLayout(new BorderLayout());


		WorkflowProcess wp = (WorkflowProcess) BPD.getInstance()
				.getActivedProcessEditor().getGraph().getPropertyObject();
		SubSystem system= null;
		try {
			system = JDSServer.getClusterClient().getSystem(JDSServer.getInstance().getCurrServerBean().getId());
		} catch (JDSException e) {
			e.printStackTrace();
		}
		OrgManager manager = OrgManagerFactory.getClientOrgManager(system.getConfigname());
	// 取得第一层的组织机构。
	OrgTree orgTree = new OrgTree(manager.getTopOrgs(system.getSysId()));
	JTree allOrgTree = new JTree(orgTree.getRoot());

	allOrgTree.setRootVisible(false);
	JPanel leftPanel = new JPanel();
	leftPanel.setLayout(new BorderLayout());
	JScrollPane orgScrollPane = new JScrollPane();
	orgScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
	orgScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
	orgScrollPane.setViewportView(allOrgTree);
	orgScrollPane.setPreferredSize(new Dimension(180, 200));
	allOrgTree.addMouseListener(new MouseAdapter() {
	    public void mouseClicked(MouseEvent me) {
		JTree tree = (JTree) me.getSource();
		TreePath selPath = tree.getSelectionPath();
		if (selPath != null) {
		    OrgTreeNode node = (OrgTreeNode) selPath.getLastPathComponent();
		    Org org = (Org) node.getUserObject();
		    if (org != null) {
			// 动态增加子节点。
			if (node.getChildren().length == 0) {
			    List<Org> childrens = org.getChildrenList();
			    for (Org corg : childrens) {
				node.insert(new OrgTreeNode(corg));
			    }
			}
			allPersonList.setListData(org.getPersonList().toArray());
		    }
		}
	    }
	});
	allOrgTree.addTreeWillExpandListener(new TreeWillExpandListener() {
	    public void treeWillExpand(TreeExpansionEvent tee) {
		TreePath selPath = tee.getPath();
		if (selPath != null) {
		    OrgTreeNode node = (OrgTreeNode) selPath.getLastPathComponent();
		    Org org = (Org) node.getUserObject();
		    if (org != null) {
			// 动态增加子节点。
			if (node.getChildren().length == 0) {
			    List<Org> childrens = org.getChildrenList();
			    for (Org corg : childrens) {
				node.insert(new OrgTreeNode(corg));
			    }
			}
			allPersonList.setListData(org.getPersonList().toArray());
		    }
		}
	    }

	    public void treeWillCollapse(TreeExpansionEvent tee) {

	    }
	});
	leftPanel.add(new JLabel("■ " + ResourceManager.getLanguageDependentString("OrgRight.Org.display")), BorderLayout.NORTH);
	leftPanel.add(orgScrollPane, BorderLayout.CENTER);
	leftPanel.add(new JLabel(" "), BorderLayout.EAST);
	JPanel rightPanel = new JPanel();
	rightPanel.setLayout(new BorderLayout());
	JScrollPane personScrollPane = new JScrollPane();
	personScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
	personScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
	personScrollPane.setViewportView(allPersonList);
	personScrollPane.setPreferredSize(new Dimension(110, 200));
	rightPanel.add(new JLabel("■ " + ResourceManager.getLanguageDependentString("OrgRight.Person.display")), BorderLayout.NORTH);
	rightPanel.add(personScrollPane, BorderLayout.CENTER);
	JPanel orgPanel = new JPanel();
	orgPanel.setLayout(new BorderLayout());
	orgPanel.setPreferredSize(new Dimension(292, 250));
	orgPanel.add(leftPanel, BorderLayout.CENTER);
	orgPanel.add(rightPanel, BorderLayout.EAST);

	// 该工作流已配置的组织机构
	Object val = myOwner.toValue();
	if (val != null) {
	    if (val instanceof XMLSelectOption) {
		elements.add(val);
	    } else {
		String person_id = val.toString();
		if (!person_id.trim().equals("")) {
		    String person_name = null;
		    try {
			person_name = manager.getPersonByID(person_id).getName();
		    } catch (PersonNotFoundException e1) {
			e1.printStackTrace();
		    }
		    if (person_name != null) {
			val = new XMLSelectOption(person_name, person_id);
			elements.add(val);
		    }
		}
	    }
	}

	final DefaultListModel listModel = new DefaultListModel();

	// fills list
	Iterator it = elements.iterator();

	while (it.hasNext()) {
	    XMLElement elem = (XMLElement) it.next();
	    listModel.addElement(elem);
	}
	// allPersonList.setModel(listModel);
	allPersonList.addMouseListener(new MouseAdapter() {
	    public void mousePressed(MouseEvent me) {
		if (me.getClickCount() > 1) {
		    addOperation();
		}
	    }
	});
	allPersonList.setSelectionMode(selectionMode);
	allPersonList.setAlignmentX(Component.LEFT_ALIGNMENT);
	allPersonList.setAlignmentY(Component.TOP_ALIGNMENT);

	JPanel buttonPanel = new JPanel();
	buttonPanel.setLayout(new FlowLayout());
	String a = ResourceManager.getLanguageDependentString("AddKey");
	String r = ResourceManager.getLanguageDependentString("RemoveKey");
	Dimension dim = new Dimension(45, 15);
	XMLButton buttonAdd = new XMLButton(a, "AddSmall", dim);
	XMLButton buttonRemove = new XMLButton(r, "RemoveSmall", dim);
	// 添加按钮的操作
	buttonAdd.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent ae) {
		addOperation();
	    }
	});
	// 删除按钮的操作
	buttonRemove.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent ae) {
		removeOperation();
	    }
	});
	buttonPanel.add(new JLabel(" "));
	buttonPanel.add(buttonAdd);
	buttonPanel.add(new JLabel(" "));
	buttonPanel.add(buttonRemove);
	buttonPanel.setPreferredSize(new Dimension(80, 60));

	JPanel choosenPanel = new JPanel();
	choosenPanel.setLayout(new BorderLayout());
	JScrollPane choosenScrollPane = new JScrollPane();
	choosenScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
	choosenScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
	choosenScrollPane.setViewportView(choosenList);
	choosenList.setModel(listModel);
	choosenList.setSelectionMode(selectionMode);
	choosenScrollPane.setPreferredSize(new Dimension(110, 200));
	choosenPanel.add(new JLabel("■ " + ResourceManager.getLanguageDependentString("OrgRight.Choosen.display")), BorderLayout.NORTH);
	choosenPanel.add(choosenScrollPane, BorderLayout.CENTER);

	jPanel.add(orgPanel, BorderLayout.WEST);
	jPanel.add(buttonPanel, BorderLayout.CENTER);
	jPanel.add(choosenPanel, BorderLayout.EAST);
	add(jPanel);
    }

    public void setElements() {
	DefaultListModel model = (DefaultListModel) getList().getModel();
	Object obj = model.get(0);
	if (obj instanceof Person) {
	    Person person = (Person) (obj);
	    obj = new XMLSelectOption(person.getName(), person.getID());
	}
	getOwner().setValue(obj);
    }

    public JList getList() {
	return choosenList;
    }

    public boolean checkRequired() {
	if (getList().getModel().getSize() == 0) {
	    XMLPanel.errorMessage(this.getDialog(), ResourceManager.getLanguageDependentString("Sys.ErrorDialog.title"), getOwner().toLabel() + ResourceManager.getLanguageDependentString("Sys.Colon"),
		    ResourceManager.getLanguageDependentString("RightFormula.Parameter.notEmptyMessage"));
	    return false;
	}
	return true;
    }

    public int getSelectionMode() {
	return selectionMode;
    }

    // 添加操作
    private void addOperation() {
	if (allPersonList.getSelectedIndex() != -1) {
	    Object selectedObj = allPersonList.getSelectedValue();
	    DefaultListModel model = (DefaultListModel) choosenList.getModel();
	    model.removeAllElements();
	    if (selectedObj instanceof Person) {
		XMLSelectOption elem = new XMLSelectOption(((Person) selectedObj).getName(), ((Person) selectedObj).getID());
		if (!model.contains(elem)) {
		    model.addElement(elem);
		}
	    }
	}
    }

    // 删除操作
    private void removeOperation() {
	if (choosenList.getSelectedIndex() != -1) {
	    DefaultListModel model = (DefaultListModel) choosenList.getModel();
	    model.remove(choosenList.getSelectedIndex());
	    if (model.size() > 0) {
		choosenList.setSelectedIndex(model.size() - 1);
	    }
	}
    }
}
