package com.ds.bpm.bpd.xml.panels.formula.iot;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.plugin.impl.activity.DicType;
import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.elements.formula.FormulaParameter;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.common.swing.tree.JDSTree;
import com.ds.common.swing.tree.JDSTreeNode;
import com.ds.config.MenuCfg;
import com.ds.iot.api.inner.IotService;
import com.ds.jds.core.esb.EsbUtil;

import javax.swing.*;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreePath;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class XMLIOTServiceTreePanel extends XMLPanel {

    private static Dimension minimalDimension = new Dimension(120, 100);

    private static Dimension listDimension = new Dimension(120, 160);

    private List elements = new ArrayList();

    private int selectionMode;

    // 可选List
    private JList allSensorList = new JList();

    // 已选List
    private JList choosenList = new JList();

    private String type;

    // 构造器----显示原有信息
    public XMLIOTServiceTreePanel(XMLElement myOwner, String title, boolean hasBorder, boolean minDimension, int selectionMode) {
	super(myOwner, 2, title, XMLPanel.BOX_LAYOUT, false, hasBorder);
	FormulaParameter formula = (FormulaParameter) myOwner;
	this.type = formula.getParam().getParameterType().getType();
	this.selectionMode = selectionMode;
	JPanel jPanel = new JPanel();
	jPanel.setLayout(new BorderLayout());

	MenuCfg menu = this.getMenus();

	JDSTreeNode jdsTreeNode = new JDSTreeNode(menu);

	JDSTree leftPanel = new JDSTree(jdsTreeNode);
	JTree dicTree = leftPanel.getTreePanel();

	dicTree.setRootVisible(false);
	dicTree.addMouseListener(new MouseAdapter() {
	    public void mouseClicked(MouseEvent me) {
		JTree tree = (JTree) me.getSource();
		TreePath selPath = tree.getSelectionPath();
		if (selPath != null && selPath.getParentPath() != null) {
		    JDSTreeNode node = (JDSTreeNode) selPath.getLastPathComponent();
		    if (node.getUserObject() instanceof MenuCfg) {

			MenuCfg cfg = (MenuCfg) node.getUserObject();
			List<MenuCfg> childcfgs = cfg.getMenu();

			String[][] items = new String[1][2];
			items[0][0] = cfg.getText();
			items[0][1] = cfg.getId();

			if (childcfgs == null || childcfgs.size() == 0) {

			} else {
			    int i = 0;
			    items = new String[childcfgs.size()][2];
			    for (MenuCfg menuCfg : childcfgs) {
				items[i][1] = menuCfg.getText();
				items[i][0] = menuCfg.getId();
				i++;
			    }

			}

			allSensorList.setListData(getDicTypes(items));

		    }
		}
	    }
	});
	dicTree.addTreeWillExpandListener(new TreeWillExpandListener() {
	    public void treeWillExpand(TreeExpansionEvent tee) {
		TreePath selPath = tee.getPath();
		if (selPath != null) {
		    JDSTreeNode node = (JDSTreeNode) selPath.getLastPathComponent();
		    if (node.getUserObject() instanceof MenuCfg) {

		    }

		}
	    }

	    public void treeWillCollapse(TreeExpansionEvent tee) {

	    }
	});
	leftPanel.add(new JLabel("■ 监听服器方法方法"), BorderLayout.NORTH);
	// leftPanel.add(orgScrollPane, BorderLayout.CENTER);
	// leftPanel.add(new JLabel(" "), BorderLayout.EAST);

	JPanel rightPanel = new JPanel();
	rightPanel.setLayout(new BorderLayout());
	JScrollPane personScrollPane = new JScrollPane();
	personScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
	personScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
	personScrollPane.setViewportView(allSensorList);
	personScrollPane.setPreferredSize(new Dimension(110, 200));
	rightPanel.add(new JLabel("■ 已选"), BorderLayout.NORTH);
	rightPanel.add(personScrollPane, BorderLayout.CENTER);
	JPanel orgPanel = new JPanel();
	orgPanel.setLayout(new BorderLayout());
	orgPanel.setPreferredSize(new Dimension(292, 250));
	orgPanel.add(leftPanel, BorderLayout.CENTER);
	orgPanel.add(rightPanel, BorderLayout.EAST);

	if (myOwner.toValue() != null && !myOwner.toValue().toString().equals("")) {
	    String val = myOwner.toValue().toString();
	    String[] vals = Utils.tokenize(val, FormulaParameter.DELIMITER_MULTIPLE);

	    for (int i = 0; i < vals.length; i++) {
		String sensor_id = vals[i];
		if (!sensor_id.trim().equals("")) {
		    String sensor_name = null;

		    if (sensor_name != null) {
			elements.add(new XMLSelectOption(sensor_name, sensor_id));
		    } else {
			elements.add(new XMLSelectOption(sensor_id, sensor_id));
		    }
		}
	    }
	}

	final DefaultListModel listModel = new DefaultListModel();

	// fills list
	Iterator it = elements.iterator();

	while (it.hasNext()) {
	    XMLElement elem = (XMLElement) it.next();
	    listModel.addElement(elem);
	}
	// allPersonList.setModel(listModel);
	allSensorList.addMouseListener(new MouseAdapter() {
	    public void mousePressed(MouseEvent me) {
		if (me.getClickCount() > 1) {
		    addOperation();
		}
	    }
	});
	allSensorList.setSelectionMode(selectionMode);
	allSensorList.setAlignmentX(Component.LEFT_ALIGNMENT);
	allSensorList.setAlignmentY(Component.TOP_ALIGNMENT);

	JPanel buttonPanel = new JPanel();
	buttonPanel.setLayout(new FlowLayout());
	String a = ResourceManager.getLanguageDependentString("AddKey");
	String r = ResourceManager.getLanguageDependentString("RemoveKey");
	Dimension dim = new Dimension(45, 15);
	XMLButton buttonAdd = new XMLButton(a, "AddSmall", dim);
	XMLButton buttonRemove = new XMLButton(r, "RemoveSmall", dim);
	// 添加按钮的操作
	buttonAdd.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent ae) {
		addOperation();
	    }
	});
	// 删除按钮的操作
	buttonRemove.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent ae) {
		removeOperation();
	    }
	});
	buttonPanel.add(new JLabel(" "));
	buttonPanel.add(buttonAdd);
	buttonPanel.add(new JLabel(" "));
	buttonPanel.add(buttonRemove);
	buttonPanel.setPreferredSize(new Dimension(80, 60));

	JPanel choosenPanel = new JPanel();
	choosenPanel.setLayout(new BorderLayout());
	JScrollPane choosenScrollPane = new JScrollPane();
	choosenScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
	choosenScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
	choosenScrollPane.setViewportView(choosenList);
	choosenList.setModel(listModel);
	choosenList.setSelectionMode(selectionMode);
	choosenScrollPane.setPreferredSize(new Dimension(110, 200));
	choosenPanel.add(new JLabel("■ 待选"), BorderLayout.NORTH);
	choosenPanel.add(choosenScrollPane, BorderLayout.CENTER);

	jPanel.add(orgPanel, BorderLayout.WEST);
	jPanel.add(buttonPanel, BorderLayout.CENTER);
	jPanel.add(choosenPanel, BorderLayout.EAST);
	add(jPanel);
    }

    public void setElements() {
	DefaultListModel model = (DefaultListModel) getList().getModel();
	String val = "";
	for (int i = 0; i < model.size(); i++) {
	    Object obj = model.get(i);
	    if (obj instanceof DicType) {
		DicType type = (DicType) (obj);
		obj = new XMLSelectOption(type.getName(), type.getType());
	    }
	    val = val + FormulaParameter.DELIMITER_MULTIPLE + ((XMLSelectOption) obj).getText();
	}
	if (!val.equals("")) {
	    val = val.substring(FormulaParameter.DELIMITER_MULTIPLE.length());
	}
	getOwner().setValue(val);
    }

    public JList getList() {
	return choosenList;
    }

    public boolean checkRequired() {
	if (getList().getModel().getSize() == 0) {
	    XMLPanel.errorMessage(this.getDialog(), ResourceManager.getLanguageDependentString("Sys.ErrorDialog.title"), getOwner().toLabel() + ResourceManager.getLanguageDependentString("Sys.Colon"),
		    ResourceManager.getLanguageDependentString("Formula.Parameter.notEmptyMessage"));
	    return false;
	}
	return true;
    }

    public int getSelectionMode() {
	return selectionMode;
    }

    // 添加操作
    private void addOperation() {
	Object[] objs = allSensorList.getSelectedValues();
	if (objs != null && objs.length > 0) {
	    DefaultListModel model = (DefaultListModel) choosenList.getModel();
	    for (int i = 0; i < objs.length; i++) {
		Object obj = objs[i];
		if (obj instanceof DicType) {
		    DicType dictype = (DicType) obj;
		    XMLSelectOption elem = new XMLSelectOption(dictype.getName(), ((DicType) obj).getType());
		    if (!model.contains(elem)) {
			model.addElement(elem);
		    }
		}
	    }
	}
    }

    // 删除操作
    private void removeOperation() {
	Object[] objs = choosenList.getSelectedValues();
	if (objs != null && objs.length > 0) {
	    DefaultListModel model = (DefaultListModel) choosenList.getModel();
	    for (int i = 0; i < objs.length; i++) {
		Object obj = objs[i];
		model.removeElement(obj);
	    }
	    if (model.size() > 0) {
		choosenList.setSelectedIndex(model.size() - 1);
	    }
	}
    }

  

    public DicType[] getDicTypes(String[][] dicArr) {

	List<DicType> sensorTypeList = new ArrayList<DicType>();

	if (dicArr != null && dicArr.length > 0) {
	    for (int i = 0; i < dicArr.length; i++) {
		String[] tmp = dicArr[i];
		DicType dictype = new DicType();
		dictype.setType(tmp[0].toLowerCase());
		dictype.setName(tmp[1].toLowerCase());
		sensorTypeList.add(dictype);
	    }
	}

	return sensorTypeList.toArray(new DicType[0]);
    }

    public MenuCfg getMenus() {
	MenuCfg menuCfg = new MenuCfg();

	IotService webservice =(IotService) EsbUtil.parExpression("$IotService");

//	try {
//	    List<MenuCfg> menuCfgs =webservice.getEsbCofig("GW", "").getData();
//	    menuCfg.setMenu(menuCfgs);
//
//	} catch (Exception ex) {
//	    ex.printStackTrace();
//	}

	return menuCfg;
    }

}
