/*
 * Created on 2004-4-6
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.panels.formula.esd;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.formula.FormulaParameter;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.common.JDSException;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.Project;
import com.ds.esd.tool.module.EUModule;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class XMLESDModulePanel extends XMLPanel {

    private static Dimension minimalDimension = new Dimension(220, 100);

    private static Dimension listDimension = new Dimension(220, 160);

    private List elements = new ArrayList();

    private int selectionMode;

    private ESDClient client;

    // 数据库表
    JList allModuleList = new JList(){

    };

    // 已选List
    private JList choosenList = new JList();


    // 构造器----显示原有信息
    public XMLESDModulePanel(XMLElement myOwner, String title,
                              boolean hasBorder, boolean minDimension, int selectionMode) throws JDSException {

        super(myOwner, 2, title, XMLPanel.BOX_LAYOUT, false, hasBorder);
        this.selectionMode = selectionMode;

        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        WorkflowProcess wp = (WorkflowProcess) BPD.getInstance()
                .getActivedProcessEditor().getGraph().getPropertyObject();
        String projectName = wp.getProjectName();
        this.client = ESDFacrory.getESDClient();

        Project project = this.client.getProjectByName(projectName);

        Set<EUModule> modules = project.getActiveProjectVersion().getAllModule();

        allModuleList.setListData(modules.toArray(new EUModule[modules.size()]));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        JScrollPane orgScrollPane = new JScrollPane();
        orgScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
        orgScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
        orgScrollPane.setViewportView(allModuleList);
        orgScrollPane.setPreferredSize(new Dimension(400, 200));
        allModuleList.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() > 1) {
                    addOperation();
                }
            }
        });

        allModuleList.setSelectionMode(selectionMode);
        leftPanel
                .add(
                        new JLabel(
                                "■ 项目页面"
                                      ),
                        BorderLayout.NORTH);
        leftPanel.add(orgScrollPane, BorderLayout.CENTER);
        JPanel moddulePanel = new JPanel();
        moddulePanel.setLayout(new BorderLayout());
        moddulePanel.setPreferredSize(new Dimension(482, 250));
        moddulePanel.add(leftPanel, BorderLayout.CENTER);

     
        if (myOwner.toValue() != null
                && !myOwner.toValue().toString().equals("")) {
            String val = myOwner.toValue().toString();
            String[] vals = Utils.tokenize(val,
                    FormulaParameter.DELIMITER_MULTIPLE);
            for (int i = 0; i < vals.length; i++) {
                String module_name = vals[i];
                if (!module_name.trim().equals("")) {
                    elements.add(module_name);
                }
            }
        }

        final DefaultListModel listModel = new DefaultListModel();

        // fills list
        Iterator it = elements.iterator();

        while (it.hasNext()) {
            listModel.addElement(it.next());
        }

        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        String a = ResourceManager.getLanguageDependentString("AddKey");
        String r = ResourceManager.getLanguageDependentString("RemoveKey");
        Dimension dim = new Dimension(45, 15);
        XMLButton buttonAdd = new XMLButton(a, "AddSmall", dim);
        XMLButton buttonRemove = new XMLButton(r, "RemoveSmall", dim);
        // 添加按钮的操作
        buttonAdd.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                addOperation();
            }
        });
        // 删除按钮的操作
        buttonRemove.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                removeOperation();
            }
        });
        buttonPanel.add(new JLabel(" "));
        buttonPanel.add(buttonAdd);
        buttonPanel.add(new JLabel(" "));
        buttonPanel.add(buttonRemove);
        buttonPanel.setPreferredSize(new Dimension(80, 60));

        JPanel choosenPanel = new JPanel();
        choosenPanel.setLayout(new BorderLayout());
        JScrollPane choosenScrollPane = new JScrollPane();
        choosenScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
        choosenScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
        choosenScrollPane.setViewportView(choosenList);
        choosenList.setModel(listModel);
        choosenList.setSelectionMode(selectionMode);
        choosenScrollPane.setPreferredSize(new Dimension(200, 200));
        choosenPanel
                .add(
                        new JLabel(
                                "■ 已选页面"
                                        ),
                        BorderLayout.NORTH);
        choosenPanel.add(choosenScrollPane, BorderLayout.CENTER);

        jPanel.add(moddulePanel, BorderLayout.WEST);
        jPanel.add(buttonPanel, BorderLayout.CENTER);
        jPanel.add(choosenPanel, BorderLayout.EAST);
        add(jPanel);
    }

    public void setElements() {
        DefaultListModel model = (DefaultListModel) getList().getModel();
        String val = "";
        for (int i = 0; i < model.size(); i++) {
            Object obj = model.get(i);
            val = val + FormulaParameter.DELIMITER_MULTIPLE + obj;
        }
        if (!val.equals("")) {
            val = val.substring(FormulaParameter.DELIMITER_MULTIPLE.length());
        }

        getOwner().setValue(val);
    }

    public JList getList() {
        return choosenList;
    }

    public boolean checkRequired() {
        if (getList().getModel().getSize() == 0) {
            XMLPanel
                    .errorMessage(
                            this.getDialog(),
                            ResourceManager
                                    .getLanguageDependentString("Sys.ErrorDialog.title"),
                            getOwner().toLabel()
                                    + ResourceManager
                                    .getLanguageDependentString("Sys.Colon"),
                            ResourceManager
                                    .getLanguageDependentString("RightFormula.Parameter.notEmptyMessage"));
            return false;
        }
        return true;
    }

    public int getSelectionMode() {
        return selectionMode;
    }

    // 添加操作
    private void addOperation() {
        Object[] objs = allModuleList.getSelectedValues();
        if (objs != null && objs.length > 0) {
            DefaultListModel model = (DefaultListModel) choosenList.getModel();
            if (getSelectionMode() == ListSelectionModel.SINGLE_SELECTION) {
                model.removeAllElements();
            }
            for (int i = 0; i < objs.length; i++) {
                Object obj = objs[i];
                if (obj instanceof EUModule) {
                    String elem = ((EUModule) obj).getName();
                    if (!model.contains(elem)) {
                        model.addElement(elem);
                    }
                }
            }
        }
    }

    // 删除操作
    private void removeOperation() {
        Object[] objs = choosenList.getSelectedValues();
        if (objs != null && objs.length > 0) {
            DefaultListModel model = (DefaultListModel) choosenList.getModel();
            for (int i = 0; i < objs.length; i++) {
                Object obj = objs[i];
                model.removeElement(obj);
            }
            if (model.size() > 0) {
                choosenList.setSelectedIndex(model.size() - 1);
            }
        }
    }
}
