/*
 * Created on 2004-4-2
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.panels.formula;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.Locale;

import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.plugin.impl.activity.ActivityRight;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.formula.Formula;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.formula.ExpressionParameter;


/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 权限公式基本信息展示面板类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-4-2 15:41:00
 * @version 1.0
 */
public class XMLFormulaDisplayPanel extends XMLPanel {

    private int panelLength = 24;

    private XMLPanel formulaPanel;

    private XMLPanel descPanel;

    private XMLPanel panel;

    /**
     * 构造器
     * 

     */
    public boolean isCn() {
	Locale obj = ResourceManager.getChoosenLocale();
	return obj.getCountry().equals("CN");

    }

    public XMLFormulaDisplayPanel(XMLElement myOwner, int noOfElements,
			String title, int layout, boolean isVertical, boolean hasBorder) {
		super(myOwner, noOfElements, title, layout, isVertical, hasBorder);
		setLayout(new BorderLayout());
		Formula rf = (Formula) myOwner;
		// 公式模板信息展示
		JEditorPane editorPane = new JEditorPane();
		editorPane.setContentType("text/html");
		StyleSheet ss = new StyleSheet();
		StringBuffer styleBuffer = new StringBuffer();
		styleBuffer.append("<style>");
		styleBuffer.append("td {font-size: 12px;}");
		styleBuffer.append("</style>");
		ss.addRule(styleBuffer.toString());
		HTMLEditorKit editorKit = new HTMLEditorKit();
		editorKit.setStyleSheet(ss);
		editorPane.setEditorKit(editorKit);
		StringBuffer sb = new StringBuffer();
		sb.append("<html><body>");
		sb.append("<table border=\"0\" width=\"100%\" valign=\"top\">");
		// 公式名称
		String nameLabel = ResourceManager
				.getLanguageDependentString("Formula.Name.display")
				+ ResourceManager.getLanguageDependentString("Sys.Colon");
		sb.append("<tr align=\"left\"><td width=\"70\">");
		sb.append(nameLabel);
		sb.append("</td><td>");
		String formulaName = rf.get("Name").toValue().toString();
		/*
		 * while (formulaName.length() > panelLength) {
		 * sb.append(formulaName.substring(0, panelLength) + "<br>");
		 * formulaName = formulaName.substring(panelLength); }
		 */
		sb.append(formulaName);
		sb.append("</td></tr>");
		// 公式内容
		sb.append("<tr align=\"left\"><td>");
		String valueLabel = ResourceManager
				.getLanguageDependentString("Formula.Value.display")
				+ ResourceManager.getLanguageDependentString("Sys.Colon");
		sb.append(valueLabel);
		sb.append("</td><td>");
		String formulaValue = rf.get("Value").toValue().toString();
		/*
		 * while (formulaValue.length() > panelLength) {
		 * sb.append(formulaValue.substring(0, panelLength) + "<br>");
		 * formulaValue = formulaValue.substring(panelLength); }
		 */
		sb.append(formulaValue);
		sb.append("</td></tr>");
		// 公式参数
		 List<ExpressionParameter>  parameters = rf.getParameters();
		if (parameters != null ) {
			String paramValue = "";
			for (ExpressionParameter parameter:parameters) {
				
				paramValue = paramValue + "; " + parameter.getParameterCode() + "(" + parameter.getParameterName()
						+ ")";
			}
			//paramValue = paramValue.substring(2);
			String paramLabel = ResourceManager
					.getLanguageDependentString("Formula.Parameter.display")
					+ ResourceManager.getLanguageDependentString("Sys.Colon");
			sb.append("<tr align=\"left\"><td>");
			sb.append(paramLabel);
			sb.append("</td><td>");
			/*
			 * while (paramValue.length() > panelLength) {
			 * sb.append(paramValue.substring(0, panelLength) + "<br>");
			 * paramValue = paramValue.substring(panelLength); }
			 */
			sb.append(paramValue);
			sb.append("</td></tr>");
		}
		// 公式描述
		String descLabel = ResourceManager
				.getLanguageDependentString("Formula.Description.display")
				+ ResourceManager.getLanguageDependentString("Sys.Colon");
		sb.append("<tr align=\"left\"><td>");
		sb.append(descLabel);
		sb.append("</td><td>");
		String formulaDesc = rf.get("Desc").toValue().toString();
		while (formulaDesc.length() > panelLength) {
			sb.append(formulaDesc.substring(0, panelLength) + "<br>");
			formulaDesc = formulaDesc.substring(panelLength);
		}
		sb.append(formulaDesc);
		sb.append("</td></tr>");
		sb.append("</table>");
		sb.append("</body></html>");
		editorPane.setText(sb.toString());
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
		scrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
		scrollPane.setViewportView(editorPane);
		scrollPane.setPreferredSize(new Dimension(350, 80));
		add(scrollPane, BorderLayout.NORTH);
		// 公式名称、描述信息展示
		JPanel centerPanel = new JPanel();
		centerPanel.setLayout(new BorderLayout());
		formulaPanel = rf.get("FormulaName").getPanel();
		descPanel = rf.get("FormulaDescription").getPanel();
		centerPanel.add(formulaPanel, BorderLayout.CENTER);
		centerPanel.add(descPanel, BorderLayout.SOUTH);
		add(centerPanel, BorderLayout.CENTER);
	}

    /**
     * 构造器
     * 
     * @param myOwner
     * @param panel
     * @param noOfElements
     * @param title
     * @param layout
     * @param isVertical
     * @param hasBorder
     */
    public XMLFormulaDisplayPanel(XMLElement myOwner, XMLPanel panel, int noOfElements, String title, int layout, boolean isVertical, boolean hasBorder) {
	this(myOwner, noOfElements, title, layout, isVertical, hasBorder);
	this.panel = panel;
	if (panel != null) {
	    String label = ResourceManager.getLanguageDependentString("Formula.Parameter.display");
	    Formula formula = (Formula) myOwner;
	    String idValue = formula.getID();
	    if (idValue.equalsIgnoreCase(ActivityRight.CUSTOMFORMULA)) {
		label = formula.get("Name").toValue().toString();
	    }
	    add(new XMLGroupPanel(myOwner, new XMLPanel[] { panel }, label), BorderLayout.SOUTH);
	}
    }

    public void setElements() {
	formulaPanel.setElements();
	descPanel.setElements();
	if (panel != null) {
	    panel.setElements();
	}
    }

    public boolean checkRequired() {
	if (!formulaPanel.checkRequired()) {
	    return false;
	}
	return true;
	// if (panel != null) {
	// return panel.checkRequired();
	// } else {
	// return true;
	// }
    }
}
