
package com.ds.bpm.bpd.xml.panels.formula;

import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;

import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.formula.FormulaCustomParameter;
import com.ds.bpm.bpd.xml.panels.XMLPanel;


public class XMLCustomFormulaPanel extends XMLPanel {

	private FormulaCustomParameter fcp;

	/**
	 * 构造器
	 */
	public XMLCustomFormulaPanel() {
		super();
	}

	/**
	 * 构造器
	 * 
	 * @param myOwner
	 */
	public XMLCustomFormulaPanel(XMLElement myOwner) {
		this(myOwner, 0, "", XMLPanel.BOX_LAYOUT, false, false);
	}

	/**
	 * 构造器
	 * 
	 * @param myOwner
	 * @param noOfElements
	 * @param title
	 * @param layout
	 * @param isVertical
	 * @param hasBorder
	 */
	public XMLCustomFormulaPanel(XMLElement myOwner, int noOfElements,
			String title, int layout, boolean isVertical, boolean hasBorder) {
		super(myOwner, noOfElements, title, layout, isVertical, hasBorder);
		this.fcp = (FormulaCustomParameter) myOwner;
		JScrollPane jsp = new JScrollPane();
		jsp.setAlignmentX(Component.LEFT_ALIGNMENT);
		jsp.setAlignmentY(Component.TOP_ALIGNMENT);

		JTextArea jta = new JTextArea();

		jta.setText(fcp.getParent().toValue().toString());
		jta.getCaret().setDot(0);
		jta.setLineWrap(true);
		jta.setWrapStyleWord(true);

		jta.setAlignmentX(Component.LEFT_ALIGNMENT);
		jta.setAlignmentY(Component.TOP_ALIGNMENT);

		jta.setEnabled(!myOwner.isReadOnly());
		jta.setFont(BPDConfig.getInstance().getFont());

		jsp.setViewportView(jta);
		jsp.setAlignmentX(Component.LEFT_ALIGNMENT);
		jsp.setAlignmentY(Component.TOP_ALIGNMENT);
		jsp.setPreferredSize(new Dimension(300, 100));
		add(jsp);
	}

	public boolean checkRequired() {
		if (isEmpty()) {
			XMLPanel
					.errorMessage(
							this.getDialog(),
							ResourceManager
									.getLanguageDependentString("Sys.ErrorDialog.title"),
							getOwner().toLabel()
									+ ResourceManager
											.getLanguageDependentString("Sys.Colon"),
							ResourceManager
									.getLanguageDependentString("RightFormula.AdvanceFormula.notEmptyMessage"));
			JScrollPane jsp = (JScrollPane) getComponent(0);
			JViewport jvp = (JViewport) jsp.getComponent(0);
			((JTextArea) jvp.getComponent(0)).requestFocus();
			return false;
		}
		return true;
	}

	public boolean isEmpty() {
		return getText().trim().equals("");
	}

	public void setElements() {
		fcp.getParent().setValue(getText());
	}

	public String getText() {
		JScrollPane jsp = (JScrollPane) getComponent(0);
		JViewport jvp = (JViewport) jsp.getComponent(0);
		return ((JTextArea) jvp.getComponent(0)).getText();
	}
}
