/* XMLTextPanel.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：文本框面板构造类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml.panels;

import java.awt.Component;
import java.awt.Dimension;

import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLElement;

/**
 * Creates panel with JLabel and JTextField.
 */
public class XMLTextPanel extends XMLPanel {

	private static Dimension textFieldDimension = new Dimension(225, 20);

	private JTextField jtf;

	// 是否居右
	private boolean isRight = true;

	// 文本框在Panel的位置
	private int index = 2;

	public static int DTDTextPanel_SMALL = 0;

	public static int DTDTextPanel_MEDIUM = 1;

	public static int DTDTextPanel_LARGE = 2;

	public XMLTextPanel(XMLElement myOwner) {
		this(myOwner, XMLPanel.BOX_LAYOUT, false, false);
	}

	public XMLTextPanel(XMLElement myOwner, int layout, boolean isVertical,
			boolean isPasswordField) {
		this(myOwner, layout, isVertical, isPasswordField, true);
	}

	public XMLTextPanel(XMLElement myOwner, int layout, boolean isVertical,
			boolean isPasswordField, boolean isRight) {
		super(myOwner, 3, "", layout, isVertical, false);
		this.isRight = isRight;
		JLabel jl = new JLabel(myOwner.toLabel()
				+ ResourceManager.getLanguageDependentString("Sys.Colon"));
		jl.setAlignmentX(Component.LEFT_ALIGNMENT);
		jl.setAlignmentY(Component.CENTER_ALIGNMENT);
		jl.setHorizontalAlignment(SwingConstants.RIGHT);

		if (!isPasswordField) {
			jtf = new JTextField();
		} else {
			jtf = new JPasswordField();
		}
		jtf.setText(myOwner.toValue().toString());
		jtf.setAlignmentX(Component.LEFT_ALIGNMENT);
		jtf.setAlignmentY(Component.CENTER_ALIGNMENT);
		jtf.setMinimumSize(new Dimension(textFieldDimension));
		jtf.setMaximumSize(new Dimension(textFieldDimension));
		jtf.setPreferredSize(new Dimension(textFieldDimension));

		jtf.setEnabled(!myOwner.isReadOnly());
		jtf.setFont(BPDConfig.getInstance().getFont());
		Dimension minSize = new Dimension(5, 10);
		Dimension prefSize = new Dimension(100, 10);
		Dimension maxSize = new Dimension(Short.MAX_VALUE, 10);

		/*
		 * if (!isVertical) { add(new Box.Filler(minSize, prefSize, maxSize)); }
		 */
		if (isRight) {
			add(Box.createHorizontalGlue());
			add(jl);
			add(jtf);
			index = 2;
		} else {
			add(jl);
			add(jtf);
			add(Box.createHorizontalGlue());
			index = 1;
		}
	}

	public boolean checkRequired() {
		if (isEmpty() && getOwner().isRequired() && !getOwner().isReadOnly()) {
			XMLPanel.defaultErrorMessage(this.getDialog(),
					((JLabel) getComponent(index - 1)).getText());
			((JTextField) getComponent(index)).requestFocus();
			return false;
		}
		return true;
	}

	public boolean isEmpty() {
		if (getComponent(index) instanceof JComboBox) {
			return true;
		}
		return getText().trim().equals("");
	}

	public void setElements() {
		Object value;
		if (getComponent(index) instanceof JComboBox) {
			value = ((JComboBox) getComponent(index)).getSelectedItem();
		} else {
			value = getText();
		}
		getOwner().setValue(value);
	}

	public String getText() {
		return ((JTextField) getComponent(index)).getText();
	}

	public void setText(String text) {
		((JTextField) getComponent(index)).setText(text);
	}

	public void requestFocus() {
		((JTextField) getComponent(index)).requestFocus();
	}

	public void updatePanel(XMLPanel p) {
		remove(getComponent(index));
		add(p.getComponent(index));
		updateUI();
	}
}
