/* XMLTabbedPanel.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：XML元素展示的XMLTabbedPanel类
 * Authors： wenzhang
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml.panels;

import java.awt.Component;

import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import com.ds.bpm.bpd.xml.XMLElement;

/**
 * Creates a tabbed panel. TabbedPanel类
 */
public class XMLTabbedPanel extends XMLPanel {
	private JTabbedPane tabbed;

	public XMLTabbedPanel(XMLElement myOwner, XMLPanel[] panels) {
		super(myOwner, 1, "", XMLPanel.BOX_LAYOUT, true, false);

		tabbed = new JTabbedPane(JTabbedPane.TOP);
		// tabbed.setLayout(new BoxLayout(this.tabbed,BoxLayout.Y_AXIS));
		// tabbed.setLayout(new GridLayout(1,1));
		tabbed.setAlignmentX(Component.LEFT_ALIGNMENT);
		tabbed.setAlignmentY(Component.TOP_ALIGNMENT);
		initialize(tabbed, panels);
		tabbed.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent ce) {
				JTabbedPane tp = (JTabbedPane) ce.getSource();
				XMLPanel panel = (XMLPanel) tp.getSelectedComponent();
				panel.panelActivated();
			}
		});

		// tabbed.setPreferredSize(tabbed.getMinimumSize());
		// elementPanel.setPreferredSize(elementPanel.getMinimumSize())
		add(tabbed);
	}
	
	public void panelActivated(){
		XMLPanel panel=(XMLPanel) this.tabbed.getSelectedComponent();
		panel.panelActivated();
	}
	

	public XMLPanel getTabbedPanel(int no) {
		if (no >= tabbed.getTabCount()) {
			return null;
		}
		return (XMLPanel) tabbed.getComponentAt(no);
	}

	public boolean checkRequired() {
		boolean isOK = true;
		for (int i = 0; i < tabbed.getComponentCount(); i++) {
			Component c = tabbed.getComponent(i);
			if (c instanceof XMLPanel) {
				isOK = isOK && ((XMLPanel) c).checkRequired();
			}
		}
		return isOK;
	}

	public void setElements() {
		for (int i = 0; i < tabbed.getComponentCount(); i++) {
			Component c = tabbed.getComponent(i);
			if (c instanceof XMLPanel) {
				((XMLPanel) c).setElements();
			}
		}
	}

	public void requestFocus() {
		if (getTabbedPanel(0) instanceof XMLGroupPanel) {
			XMLGroupPanel xgp = (XMLGroupPanel) getTabbedPanel(0);
			if (xgp.getPanel(1) != null) {
				xgp.getPanel(1).requestFocus();
			}
		}
	}

	protected void initialize(JTabbedPane tabbed, XMLPanel[] panels) {
		for (int i = 0; i < panels.length; i++) {
			if (panels[i].getTitle() != null && panels[i].getTitle() != "") {
				tabbed.addTab(panels[i].getTitle(), panels[i]);
			} else {
				tabbed.addTab(panels[i].getOwner().toLabel(), panels[i]);
			}
		}
	}
}

/* End of XMLTabbedPanel.java */
