/* XMLRadioChoicePanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;

import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLChoice;
import com.ds.bpm.bpd.xml.XMLElement;

/**
 * Creates a radio panel and a panel which type is determined by the choosen
 * element from radio panel.
 */
public class XMLRadioChoicePanel extends XMLPanel {

	XMLPanel prevPanel = null;

	public XMLRadioChoicePanel(XMLChoice myOwner) {
		this(myOwner, "");
	}

	public XMLRadioChoicePanel(XMLChoice myOwner, String title) {
		this(myOwner, title, XMLPanel.BOX_LAYOUT);
	}

	public XMLRadioChoicePanel(XMLChoice myOwner, String title, int layout) {
		this(myOwner, title, layout, true);
	}

	public XMLRadioChoicePanel(XMLChoice myOwner, String title, int layout,
			boolean isVertical) {
		this(myOwner, title, layout, isVertical, true);
	}

	public XMLRadioChoicePanel(XMLChoice myOwner, String title, int layout,
			boolean isVertical, boolean isChoiceVertical) {
		this(myOwner, title, layout, isVertical, isChoiceVertical, true);
	}

	public XMLRadioChoicePanel(XMLChoice myOwner, String title, int layout,
			boolean isVertical, boolean isChoiceVertical, boolean hasBorder) {

		super(myOwner, (myOwner instanceof XMLAttribute) ? 2 : 3, title,
				layout, isVertical, hasBorder);

		int noOfPanels = 2;
		if (myOwner instanceof XMLAttribute) {
			noOfPanels = 1;
		}

		XMLRadioPanel pRadio = new XMLRadioPanel(myOwner, "",
				XMLPanel.BOX_LAYOUT, isChoiceVertical, false);
		add(pRadio);

		if (noOfPanels == 2) {
			final JScrollPane jsp = new JScrollPane();
			jsp.setPreferredSize(new Dimension(600, 400));
			jsp.setAlignmentX(Component.LEFT_ALIGNMENT);
			jsp.setAlignmentY(Component.TOP_ALIGNMENT);
			add(jsp);
			ButtonGroup bg = pRadio.getButtonGroup();
			Enumeration e = bg.getElements();
			int i = 0;
			Object[] choices = myOwner.getChoices();
			while (e.hasMoreElements()) {
				final Object choosen = choices[i++];
				JRadioButton jr = (JRadioButton) e.nextElement();
				jr.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent ae) {
						if (prevPanel != null) {
							prevPanel.setElements();
							// ((XMLElementDialog)prevPanel.getDialog()).notifyListeners(prevPanel.getOwner());
						}
						if (choosen != null) {
							prevPanel = ((XMLElement) choosen).getPanel();
							jsp.setViewportView(prevPanel);
						}
					}
				});
				if (choosen == myOwner.getChoosen()) {
					jsp.setViewportView(((XMLElement) choosen).getPanel());
					jr.setSelected(true);
				}
			}
		}

		if (layout == XMLPanel.BOX_LAYOUT) {
			if (isVertical) {
				add(Box.createVerticalGlue());
			} else {
				add(Box.createHorizontalGlue());
			}
		}

	}

	public boolean checkRequired() {
		// check Radio panel
		boolean isOK = ((XMLPanel) getComponent(0)).checkRequired();
		// check implementation panel
		if (!(getOwner() instanceof XMLAttribute)) {
			JScrollPane jsp = (JScrollPane) getComponent(1);
			JViewport jvp = (JViewport) jsp.getComponent(0);
			isOK = isOK && ((XMLPanel) jvp.getComponent(0)).checkRequired();
		}
		return isOK;
	}

	public void setElements() {
		// setting Radio panel
		((XMLPanel) getComponent(0)).setElements();
		// setting implementation panel
		if (!(getOwner() instanceof XMLAttribute)) {
			JScrollPane jsp = (JScrollPane) getComponent(1);
			JViewport jvp = (JViewport) jsp.getComponent(0);
			((XMLPanel) jvp.getComponent(0)).setElements();
		}

	}

}

/* End of DTDRadioChoicePanel.java */
