/* XMLMultiLineTextPanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.panels;

import java.awt.Component;
import java.awt.Dimension;

import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingConstants;

import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLElement;

/**
 * Creates panel with JLabel and JTextArea.
 */
public class XMLMultiLineTextPanel extends XMLPanel {

	public static Dimension textAreaDimension = new Dimension(250, 60);

	public static Dimension miniTADimension = new Dimension(105, 60);

	public XMLMultiLineTextPanel(XMLElement myOwner) {
		this(myOwner, XMLPanel.BOX_LAYOUT);
	}

	public XMLMultiLineTextPanel(XMLElement myOwner, boolean miniDimension) {
		this(myOwner, XMLPanel.BOX_LAYOUT, false, miniDimension?false:true, true, miniDimension);
	}

	public XMLMultiLineTextPanel(XMLElement myOwner, int layout) {
		this(myOwner, layout, false, false, true, false);
	}

	public XMLMultiLineTextPanel(XMLElement myOwner, int layout,
			boolean isVertical, boolean bigPanel, boolean wrapLines,
			boolean miniDimension) {

		super(myOwner, 3, "", layout, isVertical, false);

		JScrollPane jsp = new JScrollPane();
		jsp.setAlignmentX(Component.LEFT_ALIGNMENT);
		jsp.setAlignmentY(Component.TOP_ALIGNMENT);

		JLabel jl = new JLabel(myOwner.toLabel()
				+ ResourceManager.getLanguageDependentString("Sys.Colon"));
		jl.setAlignmentX(Component.LEFT_ALIGNMENT);
		jl.setAlignmentY(Component.TOP_ALIGNMENT);
		jl.setHorizontalAlignment(SwingConstants.RIGHT);
		jl.setFont(BPDConfig.getInstance().getFont());

		JTextArea jta = new JTextArea();
		
		jta.setTabSize(4);
	
		jta.setText(myOwner.toValue().toString());
		jta.getCaret().setDot(0);
		jta.setLineWrap(wrapLines);
		jta.setWrapStyleWord(wrapLines);

		jta.setAlignmentX(Component.LEFT_ALIGNMENT);
		jta.setAlignmentY(Component.TOP_ALIGNMENT);

		jta.setEnabled(!myOwner.isReadOnly());
		jta.setFont(BPDConfig.getInstance().getFont());

		jsp.setViewportView(jta);
		jsp.setAlignmentX(Component.LEFT_ALIGNMENT);
		jsp.setAlignmentY(Component.TOP_ALIGNMENT);
		if (!bigPanel) {
			jsp.setPreferredSize(new Dimension(textAreaDimension));
		} else {
			jsp.setPreferredSize(new Dimension(400, 400));
		}
		if (miniDimension) {
			jsp.setPreferredSize(miniTADimension);
		}
		add(Box.createHorizontalGlue());
		add(jl);
		add(jsp);
	}

	public boolean checkRequired() {
		if (isEmpty() && getOwner().isRequired() && !getOwner().isReadOnly()) {

			XMLPanel.defaultErrorMessage(this.getDialog(),
					((JLabel) getComponent(1)).getText());
			JScrollPane jsp = (JScrollPane) getComponent(2);
			JViewport jvp = (JViewport) jsp.getComponent(0);
			((JTextArea) jvp.getComponent(0)).requestFocus();
			return false;
		}
		return true;
	}

	public boolean isEmpty() {
		return getText().trim().equals("");
	}

	public void setElements() {
		getOwner().setValue(getText());
	}

	public String getText() {
		JScrollPane jsp = (JScrollPane) getComponent(2);
		JViewport jvp = (JViewport) jsp.getComponent(0);
		return ((JTextArea) jvp.getComponent(0)).getText();
	}
	public void updatePanel(XMLPanel p) {
		JScrollPane jsp = (JScrollPane) getComponent(2);
		JViewport jvp = (JViewport) jsp.getComponent(0);
		jvp.remove(jvp.getComponent(0));
		
		JScrollPane pjsp = (JScrollPane) p.getComponent(2);
		JViewport pjvp = (JViewport) pjsp.getComponent(0);
		jvp.add(pjvp.getComponent(0));
		
		
	}

}
