/* XMLListControlPanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.panels;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;

/**
 * Creates a control panel for table panel. 列表控制面板
 */
public class XMLListControlPanel extends XMLControlPanel {

	public XMLListControlPanel(XMLCollection myOwner, String title,
			boolean isVertical, boolean hasBorder, boolean editButton) {

		super(myOwner, title, isVertical, hasBorder);

		controlledPanel = ((XMLCollection) myOwner).getControlledPanel();

		String a = ResourceManager.getLanguageDependentString("AddKey");
		String r = ResourceManager.getLanguageDependentString("RemoveKey");
		String e = ResourceManager.getLanguageDependentString("EditKey");

		Dimension dim;
		if (editButton) {
			dim = getPreferredDimension(new String[] { a, r });
		} else {
			dim = getPreferredDimension(new String[] { a, r, e });
		}

		final XMLButton buttonAdd = new XMLButton(a, "AddSmall", dim);
		final XMLButton buttonEdit = new XMLButton(e, "EditSmall", dim);
		final XMLButton buttonRemove = new XMLButton(r, "RemoveSmall", dim);

		buttonAdd.setEnabled(!myOwner.isReadOnly());
		buttonRemove.setEnabled(!myOwner.isReadOnly());
		add(Box.createRigidArea(new Dimension(0, 10)));
		add(buttonAdd);
		add(Box.createRigidArea(new Dimension(0, 6)));
		if (editButton) {
			add(buttonEdit);
			add(Box.createRigidArea(new Dimension(0, 6)));
		} else {
			((XMLListPanel) controlledPanel).getList().setSelectionMode(
					ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		}
		add(buttonRemove);

		buttonRemove.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JList l = ((XMLListPanel) controlledPanel).getList();
				// 没有选择元素
				if (l.getSelectedIndex() == -1) {
					JOptionPane
							.showMessageDialog(
									getDialog(),
									ResourceManager
											.getLanguageDependentString("WarningEmptySelectionToEditOrDelete"),
									ResourceManager
											.getLanguageDependentString("Title"),
									JOptionPane.WARNING_MESSAGE);
					l.setSelectedIndex(0);
					l.requestFocus();
					return;
				}

				Object[] objs = l.getSelectedValues();
				for (int i = 0; i < objs.length; i++) {
					Object obj = objs[i];
					if (((XMLElement) obj).isReadOnly()) {
						// 默认值不能删除
						continue;
					}
					if (!((XMLCollection) getOwner())
							.canRemoveElement((XMLElement) obj)) {
						String message = "";
						if (obj instanceof XMLComplexElement) {
							message = ResourceManager
									.getLanguageDependentString(((XMLCollection) getOwner())
											.getInUseMessageName((XMLComplexElement) obj));
						}
						JOptionPane.showMessageDialog(getDialog(), message,
								ResourceManager
										.getLanguageDependentString("Title"),
								JOptionPane.ERROR_MESSAGE);
						l.setSelectedIndex(0);
						l.requestFocus();
						return;
					}
				}
				int yn = JOptionPane
						.showConfirmDialog(
								getDialog(),
								ResourceManager
										.getLanguageDependentString("MessageDoYouReallyWantToRemoveSelectedItem"),
								getOwner().toLabel()
										+ " - "
										+ ResourceManager
												.getLanguageDependentString("DeletingKey"),
								JOptionPane.YES_NO_OPTION);
				if (yn == JOptionPane.YES_OPTION) {
					for (int i = 0; i < objs.length; i++) {
						Object obj = objs[i];
						DefaultListModel listModel = (DefaultListModel) l
								.getModel();
						listModel.removeElement(obj);
						((XMLCollection) getOwner()).remove(obj);
						((XMLCollection) getOwner())
								.onElementRemoved((XMLElement) obj);
					}
				} else {
					l.setSelectedIndex(0);
					l.requestFocus();
					return;
				}
			}
		});

		buttonAdd.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JList l = ((XMLListPanel) controlledPanel).getList();
				DefaultListModel listModel = (DefaultListModel) l.getModel();
				int size = listModel.getSize();

				XMLElement newElement = ((XMLCollection) getOwner())
						.generateNewElement();
				String dialogTitle;
				if (newElement instanceof XMLCollectionElement) {
					dialogTitle = ResourceManager
							.getLanguageDependentString("NewKey");
				} else {
					dialogTitle = ResourceManager
							.getLanguageDependentString("SelectKey");
				}
				String label = newElement.toLabel() + " - " + dialogTitle;
				XMLElementDialog de = new XMLElementDialog(getDialog(), label);
				XMLPanel p = newElement.getPanel();
				if (p == null) {
					return;
				}
				de.editXMLElement(p, true, false);
				// if cancel hasn't been pressed
				if (!de.isCanceled()) {
					if (!((XMLCollection) getOwner())
							.canInsertElement(newElement)) {
						return;
					}
					XMLCollection myOwner = (XMLCollection) getOwner();
					Object value = newElement.toValue();
					if (newElement instanceof XMLCollectionElement
							|| !myOwner.getValues().contains(value)) {
						listModel.addElement(newElement); // .toValue());
						l.setSelectedIndex(size);
						myOwner.add(newElement);
						myOwner.onElementInserted(newElement);
					}
				}
				l.requestFocus();
			}
		});

		// action listener for modifying selected element
		buttonEdit.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JList l = ((XMLListPanel) controlledPanel).getList();
				XMLElement editElement = null;
				try {
					editElement = (XMLElement) l.getSelectedValue();
				} catch (Exception ex) {
				}

				if (editElement != null) {
					if (editElement.isReadOnly()) {
						// 默认值不能编辑
						return;
					}
					XMLElementDialog de = new XMLElementDialog(
							getDialog(),
							editElement.toLabel()
									+ " '"
									+ editElement.toString()
									+ "' - "
									+ ResourceManager
											.getLanguageDependentString("EditingKey"));
					de.editXMLElement(editElement.getPanel(), true, false);
					if (!de.isCanceled()) {
						((XMLCollection) getOwner())
								.onElementModified(editElement);
						controlledPanel.paintAll(controlledPanel.getGraphics());
					}
				} else {
					JOptionPane
							.showMessageDialog(
									getDialog(),
									ResourceManager
											.getLanguageDependentString("WarningEmptySelectionToEditOrDelete"),
									ResourceManager
											.getLanguageDependentString("Title"),
									JOptionPane.WARNING_MESSAGE);
				}
				l.requestFocus();
			}
		});

	}
}
