/* XMLListChoicePanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.panels;

import java.awt.Component;
import java.awt.Dimension;

import javax.swing.Box;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;

/**
 * Creates a list panel and a panel which type is determined by the choosen
 * element from list panel.
 */
public class XMLListChoicePanel extends XMLPanel {

	XMLPanel prevPanel = null;

	public XMLListChoicePanel(XMLCollection myOwner) {
		this(myOwner, "");
	}

	public XMLListChoicePanel(XMLCollection myOwner, String title) {
		this(myOwner, title, XMLPanel.BOX_LAYOUT);
	}

	public XMLListChoicePanel(XMLCollection myOwner, String title, int layout) {
		this(myOwner, title, layout, true);
	}

	public XMLListChoicePanel(XMLCollection myOwner, String title, int layout,
			boolean isVertical) {
		this(myOwner, title, layout, isVertical, true);
	}

	public XMLListChoicePanel(XMLCollection myOwner, String title, int layout,
			boolean isVertical, boolean hasBorder) {

		super(myOwner, 3, title, layout, isVertical, hasBorder);

		final XMLListPanel pList = new XMLListPanel(myOwner, "", false, false,
				true);
		add(pList);
		final JScrollPane jsp = new JScrollPane();
		jsp.setAlignmentX(Component.LEFT_ALIGNMENT);
		jsp.setAlignmentY(Component.TOP_ALIGNMENT);
		jsp.setMinimumSize(new Dimension(300, 225));
		// jsp.setPreferredSize(new Dimension(300,225));
		add(jsp);

		final JList jl = pList.getList();
		jl.addListSelectionListener(new ListSelectionListener() {
			public void valueChanged(ListSelectionEvent e) {
				if (pList.isItemChangingPosition())
					return;
				if (prevPanel != null) {
					prevPanel.setElements();
					if (!getOwner().isReadOnly()) {
						XMLElementDialog.notifyListeners(prevPanel.getOwner());
					}
				}
				XMLElement choosen = null;
				try {
					choosen = (XMLElement) jl.getSelectedValue();
				} catch (Exception ex) {
				}

				if (choosen != null) {
					prevPanel = choosen.getPanel();
					jsp.setViewportView(prevPanel);
				} else {
					jsp.setViewportView(new XMLPanel());
				}
			}
		});
		jl.setSelectedIndex(0);
		if (layout == XMLPanel.BOX_LAYOUT) {
			if (isVertical) {
				add(Box.createVerticalGlue());
			} else {
				add(Box.createHorizontalGlue());
			}
		}
	}

	public JList getList() {
		return ((XMLListPanel) getComponent(0)).getList();
	}

	public void setElements() {
		// try {
		// setting List panel
		((XMLPanel) getComponent(0)).setElements();
		// setting implementation panel
		JScrollPane jsp = (JScrollPane) getComponent(1);
		JViewport jvp = (JViewport) jsp.getComponent(0);
		((XMLPanel) jvp.getComponent(0)).setElements();
		// } catch (Exception e) {}
	}

}
