/* XMLControlPanel.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：控制显示面板基类
 * Authors： wenzhang
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml.panels;

import java.awt.Dimension;

import com.ds.bpm.bpd.xml.XMLCollection;

public abstract class XMLControlPanel extends XMLPanel {
	protected XMLPanel controlledPanel;

	public XMLControlPanel(XMLCollection myOwner, String title,
			boolean isVertical, boolean hasBorder) {
		super(myOwner, 0, title, XMLPanel.BOX_LAYOUT, isVertical, hasBorder);
	}

	public void setControlledPanel(XMLPanel controlledPanel) {
		this.controlledPanel = controlledPanel;
	}

	protected Dimension getPreferredDimension(String[] s) {
		double longest = 0;
		double w = 0;
		for (int i = 0; i < s.length; i++) {
			String n = s[i];
			try {
				w = getFontMetrics(getFont()).stringWidth(s[i]);
				if (w > longest)
					longest = w;
			} catch (Exception ex) {
			}
		}
		double h = getFontMetrics(getFont()).getHeight();

		w = longest + 25;
		// w=longest+20;
		if (w < 30)
			w = 30;
		return new Dimension((int) w, (int) h);
	}

}
