/* XMLComboPanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLChoice;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLSelectOption;

/**
 * Creates panel with JLabel and JComboBox.
 */
public class XMLComboPanel extends XMLPanel {

	private Dimension comboBoxDimension = new Dimension(225, 20);

	private JComboBox jcb;

	public XMLComboPanel(XMLChoice myOwner) {
		this(myOwner, XMLPanel.BOX_LAYOUT);
	}

	public XMLComboPanel(XMLElement myOwner, Object[] choices) {
		this(myOwner, choices, XMLPanel.BOX_LAYOUT, false, false);
	}

	public XMLComboPanel(XMLChoice myOwner, int layout) {
		this(myOwner, layout, false);
	}

	public XMLComboPanel(XMLChoice myOwner, int layout, boolean isVertical) {
		this(myOwner, null, layout, isVertical, false);
	}

	public XMLComboPanel(XMLElement myOwner, Object[] choices, int layout,
			boolean isVertical, boolean isEditable) {

		super(myOwner, 2, "", layout, isVertical, false);

		JLabel jl = new JLabel(myOwner.toLabel()
				+ ResourceManager.getLanguageDependentString("Sys.Colon"));
		jl.setAlignmentX(Component.LEFT_ALIGNMENT);
		jl.setAlignmentY(Component.CENTER_ALIGNMENT);
		jl.setHorizontalAlignment(SwingConstants.RIGHT);
		jl.setFont(BPDConfig.getInstance().getFont());
		// jl.setMaximumSize(new Dimension(Short.MAX_VALUE,50));
		if (myOwner instanceof XMLChoice) {
			// jcb = new JComboBox(((XMLChoice) myOwner).getChoices());
			jcb = createComboBox(((XMLChoice) myOwner).getChoices());
			jcb.setEditable(isEditable);
			// jcb.setSelectedItem(((XMLChoice) myOwner).getChoosen());
			jcb.setSelectedItem(getItem(((XMLChoice) myOwner).getChoosen()));
			jcb.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent ie) {
					if (ie.getStateChange() == ItemEvent.SELECTED) {
						((XMLChoice) getOwner()).itemChanged(ie.getItem());
					}
				}
			});
		} else {
			jcb = new JComboBox(choices);
			jcb.setEditable(isEditable);
			jcb.setSelectedItem(myOwner.toValue());
		}

		jcb.setAlignmentX(Component.LEFT_ALIGNMENT);
		jcb.setAlignmentY(Component.CENTER_ALIGNMENT);
		jcb.setMinimumSize(new Dimension(comboBoxDimension));
		jcb.setMaximumSize(new Dimension(comboBoxDimension));
		jcb.setPreferredSize(new Dimension(comboBoxDimension));
		jcb.setEnabled(!myOwner.isReadOnly());
		jcb.setFont(BPDConfig.getInstance().getFont());

		add(Box.createHorizontalGlue());
		add(jl);
		add(jcb);

	}

	public boolean checkRequired() {
		if (getComponent(2) instanceof JTextField) {
			return true;
		}
		if ((getSelectedItem() == null || getSelectedItem().toString().trim()
				.equals(""))
				&& getOwner().isRequired() && !getOwner().isReadOnly()) {

			XMLPanel.defaultErrorMessage(this.getDialog(),
					((JLabel) getComponent(1)).getText());
			((JComboBox) getComponent(2)).requestFocus();
			return false;
		}
		return true;
	}

	public void setElements() {
		Object value;
		if (getComponent(2) instanceof JTextField) {
			value = ((JTextField) getComponent(2)).getText();
		} else {
			value = getSelectedItem();
		}
		getOwner().setValue(value);
	}

	public JComboBox getComboBox() {
		return (JComboBox) getComponent(2);
	}

	public Object getSelectedItem() {
		return getComboBox().getSelectedItem();
	}

	private JComboBox createComboBox(Object[] items) {
		JComboBox jcb = new JComboBox();
		if (items == null) {
			return jcb;
		}
		for (int i = 0; i < items.length; i++) {
			if (items[i] instanceof String[]
					&& ((String[]) items[i]).length >= 2) {
				String[] item = (String[]) items[i];
				XMLSelectOption option = new XMLSelectOption(item[0], item[1]);
				jcb.addItem(option);
			} else {
				jcb.addItem(items[i]);
			}
		}
		return jcb;
	}

	private Object getItem(Object item) {
		Object ret = item;
		if (item instanceof String[] && ((String[]) item).length >= 2) {
			String[] temp = (String[]) item;
			ret = new XMLSelectOption(temp[0], temp[1]);
		}
		return ret;
	}

	public void setItem(Object item) {
		jcb.setSelectedItem(item);
	}

	public void updatePanel(XMLPanel p) {
		remove(getComponent(2));		
		add(p.getComponent(2));
		updateUI();
	}
}
