/* XMLComboChoicePanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.panels;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLChoice;
import com.ds.bpm.bpd.xml.XMLElement;

/**
 * Creates a combo panel and a panel which type is determined by the choosen
 * element from combo panel.
 */
public class XMLComboChoicePanel extends XMLPanel {

	protected XMLPanel prevPanel = null;

	protected XMLComboPanel pCombo;

	protected JScrollPane jsp;

	public XMLComboChoicePanel(XMLChoice myOwner) {
		this(myOwner, "");
	}

	public XMLComboChoicePanel(XMLChoice myOwner, String title) {
		this(myOwner, title, XMLPanel.BOX_LAYOUT);
	}

	public XMLComboChoicePanel(XMLChoice myOwner, String title, int layout) {
		this(myOwner, title, layout, true);
	}

	public XMLComboChoicePanel(XMLChoice myOwner, String title, int layout,
			boolean isVertical) {
		this(myOwner, title, layout, isVertical, false);
	}

	public XMLComboChoicePanel(XMLChoice myOwner, String title, int layout,
			boolean isVertical, boolean isChoiceVertical) {
		this(myOwner, title, layout, isVertical, isChoiceVertical, true);
	}

	public XMLComboChoicePanel(XMLChoice myOwner, String title, int layout,
			boolean isVertical, boolean isChoiceVertical, boolean hasBorder) {

		super(myOwner, (myOwner instanceof XMLAttribute) ? 2 : 3, title,
				layout, isVertical, hasBorder);

		int noOfPanels = 2;
		if (myOwner instanceof XMLAttribute) {
			noOfPanels = 1;
		}

		pCombo = new XMLComboPanel(myOwner, XMLPanel.BOX_LAYOUT,
				isChoiceVertical);
		add(pCombo);

		if (noOfPanels == 2) {
			jsp = new JScrollPane();
			jsp.setAlignmentX(Component.LEFT_ALIGNMENT);
			jsp.setAlignmentY(Component.TOP_ALIGNMENT);
			// jsp.setMinimumSize(new Dimension(250,200));
			add(jsp);

			final JComboBox jcb = pCombo.getComboBox();
			jcb.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent ae) {
					if (prevPanel != null) {
						prevPanel.setElements();
						// ((XMLElementDialog)prevPanel.getDialog()).notifyListeners(prevPanel.getOwner());
					}
					XMLElement choosen;
					choosen = (XMLElement) jcb.getSelectedItem();
					if (choosen != null) {
						prevPanel = choosen.getPanel();
						jsp.setViewportView(prevPanel);
					}
				}
			});
			jcb.setSelectedItem(myOwner.getChoosen());
		}

		if (layout == XMLPanel.BOX_LAYOUT) {
			if (isVertical) {
				add(Box.createVerticalGlue());
			} else {
				add(Box.createHorizontalGlue());
			}
		}

	}

	public boolean checkRequired() {
		// checking Combo panel
		boolean isOK = ((XMLPanel) getComponent(0)).checkRequired();
		// checking implementation panel
		if (!(getOwner() instanceof XMLAttribute)) {
			JScrollPane jsp = (JScrollPane) getComponent(1);
			JViewport jvp = (JViewport) jsp.getComponent(0);
			if (jvp.getComponentCount() > 0) {
				XMLPanel p = (XMLPanel) jvp.getComponent(0);
				isOK = isOK && p.checkRequired();
			}
		}
		return isOK;
	}

	public void setElements() {
		// setting Combo panel
		((XMLPanel) getComponent(0)).setElements();
		// setting implementation panel
		if (!(getOwner() instanceof XMLAttribute)) {
			JScrollPane jsp = (JScrollPane) getComponent(1);
			JViewport jvp = jsp.getViewport();
			if (jvp.getComponentCount() > 0) {
				XMLPanel p = (XMLPanel) jvp.getComponent(0);
				p.setElements();
			}
		}
	}

}
