/* XMLComboButtonPanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;

/**
 * Creates panel with JLabel, JComboBox and shortcut button.
 */
public class XMLComboButtonPanel extends XMLComboPanel {

	protected XMLCollection refCollection = null;

	public XMLComboButtonPanel(XMLElement myOwner, XMLCollection c) {
		this(myOwner, null, c, XMLPanel.BOX_LAYOUT, false, false);
	}

	public XMLComboButtonPanel(XMLElement myOwner, Object[] choices,
			XMLCollection c) {
		this(myOwner, choices, c, XMLPanel.BOX_LAYOUT, false, false);
	}

	public XMLComboButtonPanel(XMLElement myOwner, Object[] choices,
			XMLCollection c, boolean isEditable) {
		this(myOwner, choices, c, XMLPanel.BOX_LAYOUT, false, isEditable);
	}

	public XMLComboButtonPanel(XMLElement myOwner, Object[] choices,
			XMLCollection c1, int layout, boolean isVertical, boolean isEditable) {

		super(myOwner, choices, layout, isVertical, isEditable);

		final JComboBox jcb = getComboBox();

		refCollection = c1;

		String s = ResourceManager.getLanguageDependentString("DefineKey");
		double w = 0;
		try {
			w = getFontMetrics(getFont()).stringWidth(s);
		} catch (Exception ex) {
		}
		double h = getFontMetrics(getFont()).getHeight();
		w += 25;
		if (w < 30)
			w = 30;
		Dimension dim = new Dimension((int) w, (int) h);

		XMLButton buttonDefine = new XMLButton(s, "Define", dim);
		buttonDefine.setAlignmentX(Component.LEFT_ALIGNMENT);
		buttonDefine.setAlignmentY(Component.BOTTOM_ALIGNMENT);
		buttonDefine.setEnabled(!myOwner.isReadOnly());

		// action listener for defining new element
		buttonDefine.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
				Object selected = jcb.getSelectedItem();
				XMLElementDialog de = new XMLElementDialog(
						getDialog(),
						refCollection.toLabel()
								+ " - "
								+ ResourceManager
										.getLanguageDependentString("DefiningKey"));
				de.editXMLElement(refCollection.getPanel(), false, false);
				if (!de.isCanceled()) {
					// refresh
					DefaultComboBoxModel dcbm = new DefaultComboBoxModel(
							refCollection.getChoosable().toArray());
					jcb.setModel(dcbm);
					if (selected != null) {
						try {
							jcb.setSelectedItem(selected);
						} catch (Exception ex) {
						}
					}
				}
			}
		});

		add(Box.createRigidArea(new Dimension(10, 0)));
		add(buttonDefine);

	}

}
