/* XMLTabbedPanel.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：XML元素展示的XMLTabbedPanel类
 * Authors： wenzhang
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml.panels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BarFactory;
import com.ds.bpm.bpd.MainCenterDownPanel;
import com.ds.bpm.bpd.MainLeftDownPanel;
import com.ds.bpm.bpd.ResourceManager;

/**
 * Creates a tabbed panel. TabbedPanel类
 */
public class TabbedPanel extends JTabbedPane {
	private AddPanelActionListener AddPanelActionListener;

	//private JTabbedPane tabbed;

	public TabbedPanel(int k) {
		super(k);
		this.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent ev) {			
				if (SwingUtilities.isRightMouseButton(ev)) {
					AbstractEditor editor = BPD.getInstance()
							.getPackageEditor();
					MainLeftDownPanel mldp = MainLeftDownPanel
							.getInstance(editor);
					MainCenterDownPanel mcdp = MainCenterDownPanel
							.getInstance(editor);
					JPopupMenu popup = new JPopupMenu();

					JMenuItem menuItem2 = BarFactory
							.createMenuItem("CloseItem");
					menuItem2.addActionListener(new ClosePanelActionListener(
							(JTabbedPane) ev.getComponent(), ((JTabbedPane) ev
									.getComponent()).getSelectedIndex()));
					JMenuItem menuItem3 = BarFactory
							.createMenuItem("AddTextTreePanel");
					menuItem3.addActionListener(new AddPanelActionListener(
							(JTabbedPane) ev.getComponent(), mldp
									.getTextTreePanel(),ResourceManager
									.getLanguageDependentString("TextTreePanel.Top.Name.display")));
					JMenuItem menuItem4 = BarFactory
							.createMenuItem("RemotePackageTreePanel");
					menuItem4.addActionListener(new AddPanelActionListener(
							(JTabbedPane) ev.getComponent(), mldp
									.getRemotePackageTreePanel(),ResourceManager
									.getLanguageDependentString("PackageTreePanel.RemoteProcessRootNode.Top.Name.display")));

					JMenuItem menuItem5 = BarFactory
							.createMenuItem("PackageTreePanel");
					menuItem5.addActionListener(new AddPanelActionListener(
							(JTabbedPane) ev.getComponent(), mldp
									.getPackageTreePanel(),ResourceManager
									.getLanguageDependentString("PackageTreePanel.LocalProcessRootNode.Top.Name.display")));
					JMenuItem menuItem6 = BarFactory
							.createMenuItem("ErrTablePanel");
					menuItem6.addActionListener(new AddPanelActionListener(
							(JTabbedPane) ev.getComponent(), mcdp.getErrTablePanel(),ResourceManager
							.getLanguageDependentString("ErrTablePanel.TableName.display")
									));
					JMenuItem menuItem7 = BarFactory
					.createMenuItem("XPDLPreviewPanel");
			       menuItem7.addActionListener(new AddPanelActionListener(
					(JTabbedPane) ev.getComponent(), mcdp.getXPDLPanel(),ResourceManager
					.getLanguageDependentString("MainCenterDownPanel.XPDLPreview.TableName.display")
							));
				   JMenuItem menuItem8= BarFactory
					.createMenuItem("TextPreviewPanel");
			       menuItem8.addActionListener(new AddPanelActionListener(
					(JTabbedPane) ev.getComponent(), mcdp.getTextPreviewPanel(),ResourceManager
					.getLanguageDependentString("MainCenterDownPanel.TextPreview.TableName.display")
							));
					popup.add(menuItem2);
					popup.add(menuItem3);
					popup.add(menuItem4);
					popup.add(menuItem5);
					popup.add(menuItem6);
					popup.add(menuItem7);
					popup.add(menuItem8);
					popup.show((JTabbedPane) ev.getComponent(), ev.getX(), ev
							.getY());
				}
			}
		});
	}


	/**
	 * Class that implements listener used for close JPane
	 */
	class ClosePanelActionListener implements ActionListener {

		private JTabbedPane sourt;

		private int k;

		public ClosePanelActionListener(JTabbedPane sourt, int k) {
			this.sourt = sourt;
			this.k = k;
		}

		public void actionPerformed(ActionEvent e) {
			sourt.remove(k);
		}
	}

	/**
	 * Class that implements listener used for expand all
	 */
	class AddPanelActionListener implements ActionListener {

		private JTabbedPane sourt;

		private JPanel jpanel;

		private String dispName;

		public AddPanelActionListener(JTabbedPane sourt, JPanel jpanel,String dispName) {
			this.sourt = sourt;
			this.jpanel = jpanel;
			this.dispName=dispName;
		}

		public void actionPerformed(ActionEvent e) {
			sourt
					.add(jpanel,
							dispName);
			sourt.setSelectedComponent(jpanel);
		}
	}

}

/* End of XMLTabbedPanel.java */
