/* XMLTableControlPanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */


package com.ds.bpm.bpd.xml.panels;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

import com.ds.bpm.bpd.xml.NewXMLCollection;
import com.ds.bpm.bpd.xml.NewXMLComplexElement;
import com.ds.bpm.bpd.xml.NewXMLElement;
import com.ds.bpm.bpd.xml.NewXMLElementDialog;
import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.tablesorting.SortingTable;

/**
 * Creates a control panel for table panel.
 */
public class NewXMLTableControlPanel extends NewXMLControlPanel {

   public NewXMLTableControlPanel (NewXMLCollection myOwner,String title,
                                boolean isVertical,boolean hasBorder) {

      super(myOwner,title,isVertical,hasBorder);

      controlledPanel=((NewXMLCollection)myOwner).getControlledPanel();

      String n=XMLUtil.getLanguageDependentString("NewLabel");
      String e=XMLUtil.getLanguageDependentString("EditKey");
      String d=XMLUtil.getLanguageDependentString("DeleteLabel");
      //String m=XMLUtil.getLanguageDependentString("MakeCopyKey");

      Dimension dim=getPreferredDimension(new String[]{n,e,d});

      XMLButton buttonNew=new XMLButton(n,"NewSmall",dim);
      XMLButton buttonEdit=new XMLButton(e,"EditCellSmall",dim);
      XMLButton buttonDelete=new XMLButton(d,"DeleteSmall",dim);
      //XMLButton buttonMakeCopy=new XMLButton(m,"CopySmall",dim);

      if (isVertical) {
         add(Box.createRigidArea(new Dimension(0,10)));
      }
      add(buttonNew);
      add(Box.createRigidArea(new Dimension((isVertical)? 0:5,(isVertical)? 5:0)));
      add(buttonEdit);
      add(Box.createRigidArea(new Dimension((isVertical)? 0:10,(isVertical)? 10:0)));
      add(buttonDelete);
      //add(Box.createVerticalGlue());
      //add(buttonMakeCopy);
      add(Box.createVerticalGlue());

      buttonNew.setEnabled(!myOwner.isReadOnly());
      buttonDelete.setEnabled(!myOwner.isReadOnly());

      // action listener for defining new element
      buttonNew.addActionListener(new ActionListener() {
               public void actionPerformed(ActionEvent ae) {
                 NewXMLElement newElement=((NewXMLCollection)getOwner()).generateNewElement();
                  NewXMLElementDialog de=new NewXMLElementDialog(getDialog(),
                                                           newElement.toLabel()+" - "+
                                                              XMLUtil.getLanguageDependentString("DefiningKey"));
                  de.editXMLElement(newElement.getPanel(),true,false);
                  // if cancel hasn't been pressed
                  if (!de.isCanceled()) {
                     addElement(newElement);
                     ((NewXMLCollection)getOwner()).onElementCreated(newElement);
                  }
               }
            });

      // action listener for modifying selected element
      buttonEdit.addActionListener(new ActionListener() {
               public void actionPerformed(ActionEvent ae) {
                  XMLElement editElement=getSelectedElement();
                  if (editElement != null) {// && !editElement.isReadOnly()) {
                     XMLElementDialog de=new XMLElementDialog(getDialog(),
                                                              editElement.toLabel()+" '"+editElement.toString()+"' - "+
                                                                 XMLUtil.getLanguageDependentString("EditingKey"));
                     de.editXMLElement(editElement.getPanel(),true,false);
                     if (!de.isCanceled()) {
                        modifyElement(editElement);
                        ((NewXMLCollection)getOwner()).onElementModified(editElement);
                     }
                  } else {
                     complainLoudly("WarningEmptySelectionToEditOrDelete");
                  }
                  ((NewXMLTablePanel)controlledPanel).getTable().requestFocus();
               }
            });

      // action listener for removing selected element
      buttonDelete.addActionListener(new ActionListener() {
               public void actionPerformed(ActionEvent ae) {
                  XMLElement deleteElement=getSelectedElement();
                  if (deleteElement == null) {
                     complainLoudly("WarningEmptySelectionToEditOrDelete");
                  } else if (deleteElement.isReadOnly()) {
                     complainLoudly(((NewXMLCollection)getOwner()).
                                       getReadOnlyMessageName((XMLComplexElement) deleteElement));
                  } else if (!((NewXMLCollection)getOwner()).canRemoveElement(deleteElement)) {
                     complainLoudly(((NewXMLCollection)getOwner()).
                                       getInUseMessageName((XMLComplexElement) deleteElement));
                  } else {
                     int yn=JOptionPane.showConfirmDialog(getDialog(),
                                                          XMLUtil.getLanguageDependentString(
                                                             "MessageDoYouReallyWantToRemoveSelectedItem"),
                                                          deleteElement.toLabel()+" - "+
                                                             XMLUtil.getLanguageDependentString("DeletingKey"),
                                                          JOptionPane.YES_NO_OPTION);
                     if (yn==JOptionPane.YES_OPTION) {
                        removeElement(deleteElement);
                        ((NewXMLCollection)getOwner()).onElementDeleted(deleteElement);
                        XMLElementDialog.notifyListeners(new XMLElement());
                     }
                  }
               }
            });

      // action listener for removing selected element
      /*buttonMakeCopy.addActionListener(new ActionListener() {
               public void actionPerformed(ActionEvent ae) {
                  XMLElement selElement=getSelectedElement();
                  if (selElement == null) {
                     complainLoudly("WarningEmptySelectionToEditOrDelete");
                  } else {
                     if (selElement instanceof XMLCollectionElement) {
                        XMLElement copyElement=XMLUtil.makeCopyOfCollectionElement((XMLCollectionElement)selElement);
                        addElement(copyElement);
                        ((XMLCollection)getOwner()).onElementCreated(copyElement);
                        XMLElementDialog.notifyListeners(new XMLElement());
                     }
                  }
               }
            });*/

   }

   public XMLElement getSelectedElement() {
      return ((NewXMLTablePanel)controlledPanel).getSelectedElement();
   }

   private void addElement(NewXMLElement e) {
      NewXMLCollection owncol=(NewXMLCollection)getOwner();
      int rowpos=owncol.size();
      owncol.add(e);
      JTable t=((NewXMLTablePanel)controlledPanel).getTable();
      DefaultTableModel dtm=(DefaultTableModel)t.getModel();
      Vector v=null;
      if (e instanceof NewXMLComplexElement) {
         v=new Vector(((NewXMLComplexElement)e).toComplexTypeValues());
      } else {
         v=new Vector();
         v.add(e.toString());
      }

      // add object itself to the first column (it is invisible column)
      v.add(0,e);
      dtm.insertRow(rowpos,v);
      //dtm.addRow(v);
      try {
         //t.setRowSelectionInterval(t.getRowCount()-1,t.getRowCount()-1);
         t.setRowSelectionInterval(rowpos,rowpos);
      } catch (Exception ex) {}
      t.requestFocus();
      if (t instanceof SortingTable) {
         ((SortingTable)t).performSorting(null);
      }
   }

   private void modifyElement(XMLElement e) {
      ((NewXMLTablePanel)controlledPanel).modifyElement((XMLComplexElement) e);
   }

   private void removeElement(XMLElement e) {
      ((NewXMLTablePanel)controlledPanel).removeElement((XMLComplexElement) e);
   }

   /**
    * Pops message into message dialog.
    */
   public void complainLoudly(String message) {
      JOptionPane.showMessageDialog(getDialog(),
                                    XMLUtil.getLanguageDependentString(message),
                                    XMLUtil.getLanguageDependentString("Title"),
                                    JOptionPane.WARNING_MESSAGE);
   }
}

