/* XMLGroupPanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */


package com.ds.bpm.bpd.xml.panels;

import java.awt.Component;

import javax.swing.Box;

import com.ds.bpm.bpd.xml.NewXMLElement;
import com.ds.bpm.bpd.xml.XMLElement;

/**
* Creates titled group panel with vertical or horizontal BoxLayout,
* that consists of panels of given elements.
*/
public class NewXMLGroupPanel extends NewXMLPanel{

   public NewXMLGroupPanel (NewXMLElement myOwner,Object[] elements) {
      this(myOwner,elements,"");
   }

   public NewXMLGroupPanel (NewXMLElement myOwner,Object[] elements,String title) {
      this(myOwner,elements,title,NewXMLPanel.BOX_LAYOUT);
   }

   public NewXMLGroupPanel (NewXMLElement myOwner,Object[] elements,String title,
      int layout) {
      this(myOwner,elements,title,layout,true);
   }

   public NewXMLGroupPanel (NewXMLElement myOwner,Object[] elements,String title,
      int layout,boolean isVertical) {
      this(myOwner,elements,title,layout,isVertical,true);
   }

   public NewXMLGroupPanel (NewXMLElement myOwner,Object[] elements,String title,
      int layout,boolean isVertical,boolean hasBorder) {

      super(myOwner,elements.length+1,title,layout,isVertical,hasBorder);

      NewXMLPanel dtdp=null;
      for (int i=0; i<elements.length; i++) {
         if (elements[i] instanceof XMLElement) {
            dtdp=((NewXMLElement)elements[i]).getPanel();
         } else if (elements[i] instanceof NewXMLPanel) {
            dtdp=(NewXMLPanel)elements[i];
         }
         dtdp.setEnabled(!myOwner.isReadOnly());
         add(dtdp);
      }

      if (isVertical) {
         add(Box.createVerticalGlue());
      }
      else {
         add(Box.createHorizontalGlue());
      }

   }

   public XMLPanel getPanel (int no) {
      if (no>=getComponentCount()-1) {
         return null;
      }
      return (XMLPanel)getComponent(no);
   }

   public boolean checkRequired () {
      if (isEmpty() && !getOwner().isRequired()) return true;
      boolean isOK=true;
      for (int i=0; i<getComponentCount();i++) {
         Component c=getComponent(i);
         if (c instanceof XMLPanel) {
            isOK=isOK && ((XMLPanel)c).checkRequired();
         }
      }
      return isOK;
   }

   public boolean isEmpty () {
      boolean isEmpty=true;
      for (int i=0; i<getComponentCount();i++) {
         Component c=getComponent(i);
         if (c instanceof XMLPanel) {
            isEmpty=isEmpty && ((XMLPanel)c).isEmpty();
         }
      }
      return isEmpty;
   }

   public void setElements () {
      boolean isOK=true;
      for (int i=0; i<getComponentCount();i++) {
         Component c=getComponent(i);
         if (c instanceof XMLPanel) {
//          System.out.println("Comp no "+(i+1)+" = "+getComponent(i));
            ((XMLPanel)c).setElements();
         }
      }
   }

}

/* End of DTDGroupPanel.java */
