/* XMLComboPanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingConstants;

import com.ds.bpm.bpd.xml.NewXMLChoice;
import com.ds.bpm.bpd.xml.NewXMLElement;

/**
 * Creates panel with JLabel and JComboBox.
 */
public class NewXMLComboPanel extends NewXMLPanel {
   
   private Dimension comboBoxDimension=new Dimension(200,20);
   
   public NewXMLComboPanel (NewXMLChoice myOwner) {
      this(myOwner,XMLPanel.BOX_LAYOUT);
   }
   
   public NewXMLComboPanel (NewXMLElement myOwner,Object[] choices) {
      this(myOwner,choices,XMLPanel.BOX_LAYOUT,false,false);
   }
   
   public NewXMLComboPanel (NewXMLChoice myOwner,int layout) {
      this(myOwner,layout,false);
   }
   
   public NewXMLComboPanel (NewXMLChoice myOwner,int layout,boolean isVertical) {
      this(myOwner,null,layout,isVertical,false);
   }
   
   public NewXMLComboPanel (NewXMLElement myOwner,Object[] choices,
                         int layout,boolean isVertical,boolean isEditable) {
      
      super(myOwner,2,"",layout,isVertical,false);
      
      JLabel jl=new JLabel(myOwner.toLabel()+" ");
      jl.setAlignmentX(Component.LEFT_ALIGNMENT);
      jl.setAlignmentY(Component.BOTTOM_ALIGNMENT);
      jl.setHorizontalAlignment(SwingConstants.RIGHT);
      //jl.setMaximumSize(new Dimension(Short.MAX_VALUE,50));
      final JComboBox jcb;
      Dimension toSet;
      if ((myOwner instanceof NewXMLChoice) && ((NewXMLChoice)myOwner).getChoices()!=null) {
         Object[] chs=((NewXMLChoice)myOwner).getChoices();
         //jcb=new JComboBox(chs);
         jcb=new JComboBox(NewXMLComboPanel.sortComboEntries(chs));
         //jcb.setMinimumSize(new Dimension(400,50));
         
         jcb.setEditable(isEditable);
         jcb.setSelectedItem(((NewXMLChoice)myOwner).getChoosen());
         toSet=getComboDimension(chs);
      } else {
         //jcb=new JComboBox(choices);
         jcb=new JComboBox(NewXMLComboPanel.sortComboEntries(choices));
         
         jcb.setEditable(isEditable);
         jcb.setSelectedItem(myOwner.toValue());
         toSet=getComboDimension(choices);
      }
      
      jcb.setAlignmentX(Component.LEFT_ALIGNMENT);
      jcb.setAlignmentY(Component.BOTTOM_ALIGNMENT);
      jcb.setMinimumSize(new Dimension(toSet));
      jcb.setMaximumSize(new Dimension(toSet));
      jcb.setPreferredSize(new Dimension(toSet));
      
      jcb.setEnabled(!myOwner.isReadOnly());
      
      add(Box.createHorizontalGlue());
      add(jl);
      add(jcb);
      
   }
   
   public boolean checkRequired () {
      if ((getSelectedItem()==null || getSelectedItem().toString().trim().equals("")) &&
          getOwner().isRequired() && !getOwner().isReadOnly()) {
         
         XMLPanel.defaultErrorMessage(this.getDialog(),((JLabel)getComponent(1)).getText());
         ((JComboBox)getComponent(2)).requestFocus();
         return false;
      }
      return true;
   }
   
   public void setElements () {
      getOwner().setValue(getSelectedItem());
   }
   
   public JComboBox getComboBox () {
      return (JComboBox)getComponent(2);
   }
   
   public Object getSelectedItem() {
      return getComboBox().getSelectedItem();
   }
   
   public Dimension getComboDimension (Object[] choices) {
      Dimension d=new Dimension(comboBoxDimension);
      double w=0;
      if (choices!=null) {
         double longest=0;
         for (int i=0;i<choices.length; i++) {
            String n=choices[i].toString();
            try {
               w=getFontMetrics(getFont()).stringWidth(choices[i].toString());
               if (w>longest) longest=w;
            } catch(Exception ex) {}
         }
         
         w=longest+25;
      }
      if (w<comboBoxDimension.width) w=comboBoxDimension.width;
      return new Dimension((int)w,comboBoxDimension.height);
      
   }
   
   public static Vector sortComboEntries (Object[] ces) {
      // do not use Arrays.asList(ces) to get list l
      java.util.List l=new ArrayList();
      if (ces!=null) {
         for (int i=0; i<ces.length; i++){
            l.add(ces[i]);
         }
      }
      
      Collections.sort(l,new ComboEntryComparator());
      return new Vector(l);
   }
   
   private static class ComboEntryComparator implements Comparator {
      public int compare(Object o1, Object o2) {
         String p1=o1.toString();
         String p2=o2.toString();
         
         return p1.compareTo(p2);
      }
   }
}

