/* XMLDataTypesPanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements.specialpanels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;

import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.ArrayType;
import com.ds.bpm.bpd.xml.elements.DataTypes;
import com.ds.bpm.bpd.xml.elements.ListType;
import com.ds.bpm.bpd.xml.panels.XMLComboPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Creates a combo panel and a panel which type is determined by the choosen
 * element from combo panel.
 */
public class XMLDataTypesPanel extends XMLPanel {

	XMLPanel prevPanel = null;

	XMLPanel emptyPanel;

	public XMLDataTypesPanel(DataTypes myOwner, String title) {

		super(myOwner, 3, title, XMLPanel.BOX_LAYOUT, true, true);

		final JScrollPane jsp = new JScrollPane();
		jsp.setAlignmentX(Component.LEFT_ALIGNMENT);
		jsp.setAlignmentY(Component.TOP_ALIGNMENT);
		int w = 550;
		int h = 250;
		int depth = getDepth();

		w = w - depth * 105;
		if (w < 330)
			w = 330;
		jsp.setPreferredSize(new Dimension(w, h));
		jsp.setMinimumSize(new Dimension(w, h));
		add(jsp);

		emptyPanel = new XMLPanel(myOwner, 2, "", XMLPanel.BOX_LAYOUT, true,
				false);
		jsp.setViewportView(emptyPanel);

		XMLComboPanel pCombo = new XMLComboPanel(myOwner);
		emptyPanel.add(pCombo);

		final JComboBox jcb = pCombo.getComboBox();
		jcb.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
				if (prevPanel != null) {
					// prevPanel.setElements();
					emptyPanel.remove(prevPanel);
				}
				XMLElement choosen;
				choosen = (XMLElement) jcb.getSelectedItem();
				if (choosen != null) {
					prevPanel = choosen.getPanel();
					emptyPanel.add(prevPanel);
				}
				jsp.paintAll(jsp.getGraphics());
			}
		});
		jcb.setSelectedItem(myOwner.getChoosen());

		add(Box.createVerticalGlue());

	}

	public boolean checkRequired() {
		boolean isOK = true;
		for (int i = 0; i < emptyPanel.getComponentCount(); i++) {
			XMLPanel p = (XMLPanel) emptyPanel.getComponent(i);
			isOK = isOK && p.checkRequired();
		}

		return isOK;
	}

	public void setElements() {
		for (int i = 0; i < emptyPanel.getComponentCount(); i++) {
			XMLPanel p = (XMLPanel) emptyPanel.getComponent(i);
			p.setElements();
		}
	}

	private int getDepth() {
		int depth = 0;
		try {
			DataTypes dtc = (DataTypes) getOwner();
			while (true) {
				XMLComplexElement cal = dtc.getOwner();
				if (cal instanceof ArrayType) {
					dtc = ((ArrayType) cal).getOwner();
				} else if (cal instanceof ListType) {
					dtc = ((ListType) cal).getOwner();
				} else {
					break;
				}
				depth++;
			}
		} catch (Exception ex) {
		}

		return depth;
	}

}
