/* XMLDataTypesPanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements.specialpanels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;

import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.XMLMultiLineTextPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Creates a combo panel and a panel which type is determined by the choosen
 * element from combo panel.
 */
public class XMLComplexContentPanel extends XMLMultiLineTextPanel {

	public XMLComplexContentPanel(XMLElement myOwner,
			final com.ds.bpm.bpd.xml.elements.Package pkg) {
		super(myOwner, XMLPanel.BOX_LAYOUT, false, true, false, false);

		String s = XMLUtil.getLanguageDependentString("NamespacesKey");
		double w = 0;
		try {
			w = getFontMetrics(getFont()).stringWidth(s);
		} catch (Exception ex) {
		}
		double h = getFontMetrics(getFont()).getHeight();
		w += 25;
		if (w < 30)
			w = 30;
		Dimension dim = new Dimension((int) w, (int) h);

		XMLButton buttonDefine = new XMLButton(s, "Define", dim);
		buttonDefine.setAlignmentX(Component.LEFT_ALIGNMENT);
		buttonDefine.setAlignmentY(Component.TOP_ALIGNMENT);
		buttonDefine.setEnabled(!myOwner.isReadOnly());
		buttonDefine.setToolTipText(XMLUtil
				.getLanguageDependentString("DefineAdditionalNamespacesKey"));
		// action listener for defining new element
		buttonDefine.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
				if (pkg == null)
					return;
				XMLPanel p = pkg.getPanel(11);
				XMLElementDialog d = new XMLElementDialog(getDialog(), XMLUtil
						.getLanguageDependentString("PackageKey")
						+ " '"
						+ pkg.toString()
						+ "' - "
						+ XMLUtil.getLanguageDependentString("NamespacesKey"));
				d.editXMLElement(p, false, false);
			}

		});

		add(Box.createRigidArea(new Dimension(10, 0)));
		add(buttonDefine);

	}

}
