/*
 * Created on 2004-2-25
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.elements.formula;

import com.ds.bpm.bpd.plugin.ExpressionElement;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.formula.XMLDefaultFormulaPanel;
import com.ds.bpm.bpd.xml.panels.formula.XMLFormulaControlPanel;
import com.ds.esb.config.formula.FormulaType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import javax.swing.*;
import java.util.*;


public class Formulas extends XMLCollection {

    // 选择模式
    private int selectionMode = ListSelectionModel.SINGLE_SELECTION;
    private FormulaType type;
    private String formulaName;



    /**
     * Constructs a RightFormula instance.

     *
     * @param myOwner
     */
    public Formulas(XMLComplexElement myOwner, FormulaType type) {
        super(myOwner, type.getType().toUpperCase());
        // this(myOwner, type.getKey(), type.getType());
        this.type = type;
        this.setLabelName(type.getName());

    }

    public Formulas(XMLComplexElement myOwner, String name, FormulaType type) {
        super(myOwner, type.getType().toUpperCase());
        this.formulaName=name;
        this.type = type;
        this.setLabelName(type.getName());

    }

    /**
     * Generates a new element of the class which instances are members of
     * collection of this class. return The generated instance of class that
     * makes collection.
     */
    public XMLElement generateNewElement() {
        Formula rf = new Formula(this, type);
        rf.setRequired(true);
        return rf;
    }

    public XMLPanel getPanel() {
        controlledPanel = new XMLDefaultFormulaPanel(this, "", false, false);
        controlPanel = new XMLFormulaControlPanel(this, "", true, false);
        return new XMLGroupPanel(this, new XMLPanel[]{controlledPanel,
                controlPanel}, toLabel(), XMLPanel.BOX_LAYOUT, false, true);
    }



    public String getFormulaName() {
        return formulaName;
    }

    public void setFormulaName(String formulaName) {
        this.formulaName = formulaName;
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    public int getSelectionMode() {
        return selectionMode;
    }

    public int[] getInvisibleTableFieldOrdinals() {
        return new int[]{0, 3, 4};
    }

    public void toXML(Node parent) {
        if (parent != null) {
            Element elem = parent.getOwnerDocument().createElement(
                    "ExtendedAttribute");
            elem.setAttribute("Name", toName());
            elem.setAttribute("Type", type.getBaseType().getType());
            elem.setAttribute("Value", "");
            parent.appendChild(elem);
            // 记录公式集中各个公式的顺序
            if (refCollectionElements.size() > 0) {
                int index = 1;
                for (Iterator it = refCollectionElements.iterator(); it.hasNext(); ) {
                    Formula rf = (Formula) it.next();
                    rf.setOrder(index++);
                    rf.toXML(parent);
                }
            }

        }
    }

    public void afterImporting(List elems) {
        if (elems == null || elems.size() == 0) {
            return;
        }
        Map formulaMap = new HashMap();
        for (Iterator it = elems.iterator(); it.hasNext(); ) {
            ExtendedAttribute ea = (ExtendedAttribute) it.next();
            String nm = ea.get("Name").toValue().toString();
            if (nm.startsWith(toName() + "." + ExpressionElement.FORMULA_NAME)) {
                nm = nm.substring((toName() + ".").length());
                if (nm.indexOf(".") != -1) {
                    String formulaName = nm.substring(0, nm.indexOf("."));
                    List list = null;
                    if (formulaMap.get(formulaName) == null) {
                        list = new ArrayList();
                    } else {
                        list = (List) formulaMap.get(formulaName);
                    }
                    list.add(ea);
                    formulaMap.put(formulaName, list);
                }
            }
        }

        for (Iterator it = formulaMap.entrySet().iterator(); it.hasNext(); ) {
            Map.Entry entry = (Map.Entry) it.next();
            Formula rf = (Formula) generateNewElement();
            add(rf);
            rf.afterImporting((List) entry.getValue());
        }
    }
    public FormulaType getType() {
        return type;
    }

    public void setType(FormulaType type) {
        this.type = type;
    }

    // 实现clone方法
    public Object clone() {
        Formulas rfs = (Formulas) super.clone();
        return rfs;
    }
}
