/*
 * Created on 2004-4-1
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.elements.formula;

import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.formula.ExpressionParameter;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 公式参数数据类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 *
 * @author Huchm 2004-4-1 13:27:05
 * @version 1.0
 */
public class FormulaParameter extends XMLComplexElement {

    public static final String DELIMITER_MULTIPLE = ":";

    protected ExpressionParameter param = null;

    protected Formula parent;

    public FormulaParameter() {
        super();
    }

    /**
     * @param parent
     * @param param
     */
    public FormulaParameter(Formula parent, ExpressionParameter param) {
        this.parent = parent;
        this.param = param;
        if (param != null) {
            setLabelName(param.getParameterName());
        }
    }

    public String getParamValue() {
        return "";
    }

    public Formula getParent() {
        return parent;
    }

    // 实现clone方法
    public Object clone() {
        FormulaParameter fp = (FormulaParameter) super.clone();
        return fp;
    }

    public ExpressionParameter getParam() {
        return param;
    }

    public void setParam(ExpressionParameter param) {
        this.param = param;
    }
}
