
package com.ds.bpm.bpd.xml.elements.formula;

import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.formula.XMLEnumsDicPanel;
import com.ds.bpm.enums.formula.FormulaParamsDIC;
import com.ds.bpm.formula.ExpressionParameter;
import com.ds.esb.config.formula.FormulaParams;

import javax.swing.*;

public class FormulaEnumsValueParameter extends FormulaParameter {

    private static final long serialVersionUID = 1L;

    private FormulaParams formulaParams;

    /**
     * 构造器
     */
    public FormulaEnumsValueParameter() {
        super();
    }

    /**
     * 构造器
     *
     * @param parent
     * @param param
     */
    public FormulaEnumsValueParameter(Formula parent, ExpressionParameter param) {
        super(parent, param);
        this.formulaParams = param.getParameterType();

    }

    public XMLPanel getPanel() {
        String title = param.getParameterDesc();
        if (title == null || title.trim().equals("")) {
            title = param.getParameterName();
        }
        return new XMLEnumsDicPanel(this, title, true, true, ListSelectionModel.SINGLE_SELECTION, FormulaParamsDIC.fromType(formulaParams.getType()).getDicClass());
    }

    public String getParamValue() {
        String val = param.getParameterCode() + "=";
        val = val + toValue().toString();
        return val;
    }
}
