
package com.ds.bpm.bpd.xml.elements.formula;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.enums.FormulaEnums;
import com.ds.bpm.bpd.plugin.ExpressionElement;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTabbedPanel;
import com.ds.bpm.bpd.xml.panels.XMLTextPanel;
import com.ds.bpm.bpd.xml.panels.formula.XMLFormulaDisplayPanel;
import com.ds.bpm.bpd.xml.panels.formula.XMLFormulaPanel;
import com.ds.bpm.formula.ExpressionParameter;
import com.ds.bpm.formula.ParticipantSelect;
import com.ds.esb.config.formula.FormulaType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import javax.swing.*;
import java.lang.reflect.Constructor;
import java.util.*;

public class Formula extends XMLCollectionElement {

    // 模板名称
    private XMLAttribute attrName = new XMLAttribute("Name");

    // 模板内容
    private XMLAttribute attrValue = new XMLAttribute("Value");

    // 模板描述
    private XMLAttribute attrDesc = new XMLAttribute("Desc");

    // 公式名称
    private XMLAttribute formulaName = new XMLAttribute("FormulaName") {
        public XMLPanel getPanel() {
            return new XMLTextPanel(this, XMLPanel.BOX_LAYOUT, false, false, false);
        }
    };

    // 公式描述
    private XMLAttribute formulaDesc = new XMLAttribute("FormulaDescription") {
        public XMLPanel getPanel() {
            return new XMLTextPanel(this, XMLPanel.BOX_LAYOUT, false, false, false);
        }
    };
//
//    // 模板参数
//    private List<ExpressionParameter> parameters;

    // 模板参数值
    private Map paramMap = new HashMap();

    // 参数值对的分隔符
    private static final String VALUES_DELIMITER = ";";

    // 本公式的顺序号
    private int index = 1;

    private FormulaType type;


    /**
     * Constructs a RightFormula instance.
     *
     * @param myCollection
     */
    public Formula(XMLCollection myCollection, FormulaType type) {
        super(myCollection);
        this.type = type;
        // 初始化界面
        setLabelName(getCollection().toLabel());
        attrId.setLabelName(ResourceManager.getLanguageDependentString("Formula.Id.display"));
        attrName.setLabelName(ResourceManager.getLanguageDependentString("Formula.Name.display"));
        attrValue.setLabelName(ResourceManager.getLanguageDependentString("Formula.Value.display"));
        attrDesc.setLabelName(ResourceManager.getLanguageDependentString("Formula.Description.display"));
        formulaName.setLabelName(ResourceManager.getLanguageDependentString("Formula.FormulaName.display"));
        formulaName.setRequired(true);
        formulaDesc.setLabelName(ResourceManager.getLanguageDependentString("Formula.FormulaDescription.display"));
        fillStructure();
    }

    protected void fillStructure() {
        super.fillStructure();
        complexStructure.add(formulaName);
        complexStructure.add(attrName);
        complexStructure.add(attrValue);
        complexStructure.add(attrDesc);
        complexStructure.add(formulaDesc);
    }

    public XMLPanel getPanel() {
        ExpressionElement ar = (ExpressionElement) getCollection().getOwner();

        List<ParticipantSelect> formulas = ar.getFormulas(type);

        String[] advanceFormula = new String[]{ExpressionElement.CUSTOMFORMULA,

                ResourceManager.getLanguageDependentString("Formula.AdvanceFormula.Name"),

                ResourceManager.getLanguageDependentString("Formula.AdvanceFormula.Name"),

                ResourceManager.getLanguageDependentString("Formula.AdvanceFormula.Description")

        };
        String[][] formulaArr = new String[formulas.size() + 1][6];

        int i = 0;
        // String[] selectArr=new String[]{select.getSelectName(),};
        for (ParticipantSelect select : formulas) {
            formulaArr[i][0] = select.getParticipantSelectId();
            formulaArr[i][1] = select.getSelectName();
            formulaArr[i][2] = select.getFormula();
            formulaArr[i][3] = select.getSelectDesc();
            formulaArr[i][4] = select.getSelectenName();
            formulaArr[i][5] = select.getFormulaType().getType();
            i = i + 1;

        }
        formulaArr[formulas.size()] = advanceFormula;

        return new XMLFormulaPanel(this, formulaArr, getCollection().toLabel(), true, false, false, ListSelectionModel.SINGLE_SELECTION);
    }

    public boolean isCn() {
        Locale obj = ResourceManager.getChoosenLocale();
        return obj.getCountry().equals("CN");

    }

    public void saveValue(Object value) {
        if (value == null || !(value instanceof String[])) {
            return;
        }
        String[] val = (String[]) value;
        if (val.length >= 6) {
            attrId.setValue(val[0]);
            attrName.setValue(val[1]);
            attrValue.setValue(val[2]);
            attrDesc.setValue(val[3]);
            formulaName.setValue(val[4]);
            formulaDesc.setValue(val[5]);

        }
    }

    public String toString() {
        return attrName.toValue().toString();
    }

    public List<ExpressionParameter> getParameters() {
        ExpressionElement ar = (ExpressionElement) getCollection().getOwner();
        List<ExpressionParameter> parameters = ar.getFormulaParameters(attrId.toValue().toString());
        return parameters;

    }


    // 配置参数信息
    public boolean configConfigParameters(JDialog dialog) {
        List<ExpressionParameter> params = getParameters();
        XMLElementDialog de = new XMLElementDialog(dialog, ResourceManager.getLanguageDependentString("Formula.display") + " - " + ResourceManager.getLanguageDependentString("ConfigKey"));
        // 配置参数Panel
        XMLPanel panel = null;
        String idValue = attrId.toValue().toString();
        if (idValue.startsWith(ExpressionElement.CUSTOMFORMULA)) {
            // 配置高级公式

            FormulaParameter fp = (FormulaParameter) paramMap.get(idValue);
            if (fp == null) {
                fp = new FormulaCustomParameter(this, null);
                panel = fp.getPanel();
            }

        } else

        {
            // 不用配置参数
            if (params.size() == 0) {
                // return true;
            } else {
                // 配置一般公式
                List panels = new ArrayList();

                for (ExpressionParameter param : params) {

                    if (param.getParameterType() != null) {
                        String type = param.getParameterType().getType();
                        FormulaParameter fp = (FormulaParameter) paramMap.get(param.getParameterId());
                        if (fp == null) {
                            fp = createFormulaParameter(FormulaEnums.fromName(type), param);
                        }
                        if (fp != null) {
                            panels.add(fp.getPanel());
                            paramMap.put(param.getParameterId(), fp);
                        }

                    }

                }
                panel = new XMLTabbedPanel(this, (XMLPanel[]) panels.toArray(new XMLPanel[panels.size()])) {
                    protected void initialize(JTabbedPane tabbed, XMLPanel[] panels) {
                        for (int i = 0; i < panels.length; i++) {
                            if (panels[i].getOwner().toLabel() != null && panels[i].getOwner().toLabel() != "") {
                                tabbed.addTab(panels[i].getOwner().toLabel(), panels[i]);
                            } else {
                                tabbed.addTab(panels[i].getTitle(), panels[i]);
                            }
                        }
                    }
                };
            }
        }
        de.editXMLElement(new XMLFormulaDisplayPanel(this, panel, 0, ResourceManager.getLanguageDependentString("Formula.display"), XMLPanel.BOX_LAYOUT, true, true), true, false);
        if (de.isCanceled())

        {
            return false;
        }
        return true;

    }

    // 配置参数信息
    public boolean configParameters(JDialog dialog) {
        List<ExpressionParameter> params = getParameters();

        XMLElementDialog de = new XMLElementDialog(dialog, ResourceManager.getLanguageDependentString("Formula.display") + " - " + ResourceManager.getLanguageDependentString("ConfigKey"));
        // 配置参数Panel
        XMLPanel panel = null;
        String idValue = attrId.toValue().toString();
        if (idValue.startsWith(ExpressionElement.CUSTOMFORMULA)) {
            // 配置高级公式

            FormulaParameter fp = (FormulaParameter) paramMap.get(idValue);
            if (fp == null) {
                fp = new FormulaCustomParameter(this, null);
                panel = fp.getPanel();
            }

        } else

        {
            // 不用配置参数
            if (params.size() == 0) {
                // return true;
            } else {
                // 配置一般公式
                List panels = new ArrayList();

                for (ExpressionParameter param : params) {

                    if (param.getParameterType() != null) {
                        String type = param.getParameterType().getType();
                        FormulaParameter fp = (FormulaParameter) paramMap.get(param.getParameterId());
                        if (fp == null && FormulaEnums.fromName(type) != null) {
                            fp = createFormulaParameter(FormulaEnums.fromName(type), param);
                        }
                        if (fp != null) {
                            panels.add(fp.getPanel());
                            paramMap.put(param.getParameterId(), fp);
                        }

                    }

                }
                panel = new XMLTabbedPanel(this, (XMLPanel[]) panels.toArray(new XMLPanel[panels.size()])) {
                    protected void initialize(JTabbedPane tabbed, XMLPanel[] panels) {
                        for (int i = 0; i < panels.length; i++) {
                            if (panels[i].getOwner().toLabel() != null && panels[i].getOwner().toLabel() != "") {
                                tabbed.addTab(panels[i].getOwner().toLabel(), panels[i]);
                            } else {
                                tabbed.addTab(panels[i].getTitle(), panels[i]);
                            }
                        }
                    }
                };
            }
        }
        de.editXMLElement(new XMLFormulaDisplayPanel(this, panel, 0, ResourceManager.getLanguageDependentString("Formula.display"), XMLPanel.BOX_LAYOUT, true, true), true, false);
        if (de.isCanceled())

        {
            return false;
        }
        return true;

    }

    public void toXML(Node parent) {
        if (parent != null) {
            Element elem = parent.getOwnerDocument().createElement("ExtendedAttribute");
            String nm = getCollection().toName() + "." + ExpressionElement.FORMULA_NAME + String.valueOf(index);
            elem.setAttribute("Name", nm);
            elem.setAttribute("Type", type.getBaseType().getType());
            elem.setAttribute("Value", attrId.toValue().toString());
            parent.appendChild(elem);
            // 公式名称
            elem = parent.getOwnerDocument().createElement("ExtendedAttribute");
            elem.setAttribute("Name", nm + ".NAME");
            elem.setAttribute("Type", type.getBaseType().getType());
            elem.setAttribute("Value", formulaName.toValue().toString());
            parent.appendChild(elem);
            // 公式描述
            elem = parent.getOwnerDocument().createElement("ExtendedAttribute");
            elem.setAttribute("Name", nm + ".DESCRIPTION");
            elem.setAttribute("Type", type.getBaseType().getType());
            elem.setAttribute("Value", formulaDesc.toValue().toString());
            parent.appendChild(elem);
            // 公式信息
            String idValue = getID();
            elem = parent.getOwnerDocument().createElement("ExtendedAttribute");
            elem.setAttribute("Name", nm + "." + idValue);
            elem.setAttribute("Type", type.getBaseType().getType());
            String val = "";
            // 高级公式
            if (idValue.equalsIgnoreCase(ExpressionElement.CUSTOMFORMULA)) {
                val = toValue().toString();
            } else {
                for (Iterator it = paramMap.entrySet().iterator(); it.hasNext(); ) {
                    Map.Entry entry = (Map.Entry) it.next();
                    FormulaParameter fp = (FormulaParameter) entry.getValue();
                    val = val + Formula.VALUES_DELIMITER + fp.getParamValue();
                }
                if (!val.equals("")) {
                    val = val.substring(Formula.VALUES_DELIMITER.length());
                }
            }
            elem.setAttribute("Value", val);
            parent.appendChild(elem);
        }
    }

    public void afterImporting(List list) {
        if (list == null || list.size() == 0) {
            getCollection().remove(this);
            return;
        }
        for (Iterator it = list.iterator(); it.hasNext(); ) {
            ExtendedAttribute ea = (ExtendedAttribute) it.next();
            String nm = ea.get("Name").toValue().toString();
            nm = nm.substring((getCollection().toName() + ".").length());
            if (nm.indexOf(".") != -1) {
                nm = nm.substring(nm.indexOf(".") + 1);
                String value = ea.get("Value").toValue().toString();
                // 公式名称
                if (nm.equalsIgnoreCase("NAME")) {
                    formulaName.setValue(value);
                    continue;
                }
                // 公式描述
                if (nm.equalsIgnoreCase("DESCRIPTION")) {
                    formulaDesc.setValue(value);
                    continue;
                }
                attrId.setValue(nm);
                // 高级公式
                if (nm.equalsIgnoreCase(ExpressionElement.CUSTOMFORMULA)) {
                    attrName.setValue(ResourceManager.getLanguageDependentString("Formula.AdvanceFormula.Name"));
                    attrValue.setValue(ResourceManager.getLanguageDependentString("Formula.AdvanceFormula.Name"));
                    attrDesc.setValue(ResourceManager.getLanguageDependentString("Formula.AdvanceFormula.Description"));
                    setValue(value);
                } else {
                    // 一般公式
                    ExpressionElement ar = (ExpressionElement) getCollection().getOwner();
                    List<ParticipantSelect> formulas = ar.getFormulas(type);
                    ParticipantSelect formula = ar.getFormula(formulas, nm);

                    if (formula == null) {
                        getCollection().remove(this);
                    } else {
                        attrName.setValue(formula.getSelectName());
                        attrValue.setValue(formula.getFormula());
                        attrDesc.setValue(formula.getSelectDesc());
                        String[] vals = Utils.tokenize(value, Formula.VALUES_DELIMITER);
                        // 设置参数
                        List<ExpressionParameter> params = getParameters();

                        for (ExpressionParameter param : params) {

                            if (param.getParameterType() != null) {
                                String type = param.getParameterType().getType();
                                if (FormulaEnums.fromName(type) != null) {
                                    FormulaParameter fp = createFormulaParameter(FormulaEnums.fromName(type), param);
                                    if (fp != null) {
                                        fp.setValue(getParameterValue(vals, param.getParameterCode()));
                                        paramMap.put(param.getParameterId(), fp);
                                    }
                                }


                            }

                        }

                    }
                }
            }
        }
    }

    // 创建参数信息
    private FormulaParameter createFormulaParameter(FormulaEnums enums, ExpressionParameter param) {
        FormulaParameter fp = null;

        try {

            Constructor formulConstructor = enums.getClazz().getConstructor(Formula.class, ExpressionParameter.class);
            fp = (FormulaParameter) formulConstructor.newInstance(this, param);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        return fp;
    }

    private String getParameterValue(String[] vals, String name) {
        String ret = "";
        if (vals == null || vals.length == 0) {
            return ret;
        }
        for (int i = 0; i < vals.length; i++) {
            String val = vals[i];
            if (val.startsWith(name)) {
                ret = val.substring((name + "=").length());
                return ret;
            }
        }
        return ret;
    }

    public void setOrder(int index) {
        this.index = index;
    }

    public int[] getInvisibleTableFieldOrdinals() {

        return new int[]{0, 3};

    }

    // 实现clone方法
    public Object clone() {
        Formula rf = (Formula) super.clone();
        rf.formulaName = (XMLAttribute) this.formulaName.clone();
        rf.attrName = (XMLAttribute) this.attrName.clone();
        rf.attrValue = (XMLAttribute) this.attrValue.clone();
        rf.attrDesc = (XMLAttribute) this.attrDesc.clone();
        rf.formulaDesc = (XMLAttribute) this.formulaDesc.clone();
        // clone公式参数
        rf.paramMap = new HashMap();
        for (Iterator it = paramMap.entrySet().iterator(); it.hasNext(); ) {
            Map.Entry entry = (Map.Entry) it.next();
            rf.paramMap.put(entry.getKey(), ((FormulaParameter) (entry.getValue())).clone());
        }
        rf.fillStructure();
        return rf;
    }
}
