
package com.ds.bpm.bpd.xml.elements.event;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import com.ds.bpm.enums.command.CommonEnums;
import org.w3c.dom.Node;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.enums.EnumsUtil;

public class ActivityEventSimple extends ActivityEventBase {

    private XMLAttribute durationUnit = new XMLAttribute(EnumsUtil.getAttribute(CommonEnums.DurationUnit));
    // 预警时间
    private XMLAttribute alertTime = new XMLAttribute(CommonEnums.AlertTime.getType(), CommonEnums.AlertTime.getDisplayName());

    // 构造器
    public ActivityEventSimple(WorkflowProcess process, Activity act) {
	super(process, act);

	// 初始化页面显示属性
	setLabelName(ResourceManager.getLanguageDependentString("Activity.ActivityEvent.display"));
	fillStructure();
    }

    protected void fillStructure() {

	super.fillStructure();

	if (!complexStructure.contains(limit)) {
	    complexStructure.add(limit);
	}

	complexStructure.add(alertTime);

	complexStructure.add(durationUnit);

//	if (!complexStructure.contains(join)) {
//	    complexStructure.add(join);
//	}
//
//	if (!complexStructure.contains(split)) {
//	    complexStructure.add(split);
//	}
//
    }

    // 把活动办理权限信息保存在XML文件中
    public void toXML(Node parent) {
	super.toXML(parent);

    }

    // 从活动扩展属性保存到活动事件对象
    public void afterImporting() {
	ExtendedAttributes exAttrs = (ExtendedAttributes) act.get("ExtendedAttributes");
	Set easToRemove = new HashSet();
	Iterator it = exAttrs.toCollection().iterator();
	String nm = "";
	String val = "";
	while (it.hasNext()) {
	    ExtendedAttribute ea = (ExtendedAttribute) it.next();
	    nm = ea.get("Name").toValue().toString();
	    val = ea.get("Value").toValue().toString();
	    if (nm.equalsIgnoreCase("DurationUnit")) {
		durationUnit.setValue(val);
		durationUnit.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }
	    if (nm.equalsIgnoreCase("DurationUnit")) {
		durationUnit.setValue(val);
		durationUnit.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }

	    if (nm.equalsIgnoreCase("AlertTime")) {
		alertTime.setValue(val);
		alertTime.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }

	}

	exAttrs.toCollection().removeAll(easToRemove);
    }

    // 解析XPDL文件保存到活动事件对象
    public void fromXML(Node node) {

	super.fromXML(node);

    }

    // 实现Clone方法
    public ActivityEventSimple clone() {
	ActivityEventSimple ae = (ActivityEventSimple) super.clone();

	ae.durationUnit = (XMLAttribute) this.durationUnit.clone();
	ae.alertTime = (XMLAttribute) this.alertTime.clone();

	ae.fillStructure();
	return ae;
    }
}
