/*
 * Created on 2004-1-9
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.elements.event;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import com.ds.bpm.enums.command.CommonEnums;
import org.w3c.dom.Node;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.enums.DeviceDefEnums;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.panels.XMLComboPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.enums.EnumsUtil;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 活动事件类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author wenzhang 2004-1-9 21:58:51
 * @version 1.0
 */
public class ActivityEventDevice extends ActivityEventBase {

    private XMLAttribute durationUnit = new XMLAttribute(EnumsUtil.getAttribute(CommonEnums.DurationUnit));

    // 预警时间
    private XMLAttribute alertTime = new XMLAttribute("AlertTime");

    private XMLAttribute deadLineOperation = new XMLAttribute(EnumsUtil.getAttribute(DeviceDefEnums.DeadLineOperation));

    private XMLAttribute canSpecialSend = new XMLAttribute(EnumsUtil.getAttribute(DeviceDefEnums.CanSpecialSend)) {

	public void itemChanged(Object o) {
	    XMLSelectOption selectOption = (XMLSelectOption) o;
	    String textname = selectOption.getText();

	    if (!textname.equals("YES")) {
		XMLComboPanel panel = (XMLComboPanel) ActivityEventDevice.this.specialScope.getOldPanel();
		ActivityEventDevice.this.specialScope.setChoosenIndex(0);
		ActivityEventDevice.this.specialScope.setReadOnly(true);
		XMLComboPanel newpanel = (XMLComboPanel) new XMLComboPanel(ActivityEventDevice.this.specialScope, XMLPanel.BOX_LAYOUT, false);
		panel.updatePanel(newpanel);
	    } else {
		XMLComboPanel panel = (XMLComboPanel) ActivityEventDevice.this.specialScope.getOldPanel();
		ActivityEventDevice.this.specialScope.setChoosenIndex(0);
		ActivityEventDevice.this.specialScope.setReadOnly(false);
		XMLComboPanel newpanel = (XMLComboPanel) new XMLComboPanel(ActivityEventDevice.this.specialScope, XMLPanel.BOX_LAYOUT, false);
		panel.updatePanel(newpanel);
	    }
	}
    };

    private XMLAttribute specialScope = new XMLAttribute(EnumsUtil.getAttribute(DeviceDefEnums.SpecialScope));

    // 构造器
    public ActivityEventDevice(WorkflowProcess process, Activity act) {
	super(process, act);
	this.act = act;
	// 初始化页面显示属性
	//setLabelName(ResourceManager.getLanguageDependentString("Activity.ActivityEvent.display"));
	alertTime.setLabelName(ResourceManager.getLanguageDependentString("Activity.ActivityEvent.AlertTime.display"));
	fillStructure();
    }

    protected void fillStructure() {
	specialScope.setReadOnly(true);
	complexStructure.add(durationUnit);
	complexStructure.add(alertTime);
	complexStructure.add(deadLineOperation);
	complexStructure.add(canSpecialSend);
	complexStructure.add(specialScope);
	super.fillStructure();

    }

    // 把活动办理权限信息保存在XML文件中
    public void toXML(Node parent) {
	super.toXML(parent);

    }

    // 从活动扩展属性保存到活动事件对象
    public void afterImporting() {
	ExtendedAttributes exAttrs = (ExtendedAttributes) act.get("ExtendedAttributes");
	Set easToRemove = new HashSet();
	Iterator it = exAttrs.toCollection().iterator();
	String nm = "";
	String val = "";
	while (it.hasNext()) {
	    ExtendedAttribute ea = (ExtendedAttribute) it.next();
	    nm = ea.get("Name").toValue().toString();
	    val = ea.get("Value").toValue().toString();
	    if (nm.equalsIgnoreCase("DurationUnit")) {
		durationUnit.setValue(val);
		durationUnit.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }
	    if (nm.equalsIgnoreCase("DurationUnit")) {
		durationUnit.setValue(val);
		durationUnit.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }

	    if (nm.equalsIgnoreCase("AlertTime")) {
		alertTime.setValue(val);
		alertTime.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }

	    if (nm.equalsIgnoreCase("DeadLineOperation")) {
		deadLineOperation.setValue(val);
		deadLineOperation.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }

	    if (nm.equalsIgnoreCase("CanSpecialSend")) {
		canSpecialSend.setValue(val);
		canSpecialSend.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }
	    if (nm.equalsIgnoreCase("SpecialScope")) {
		specialScope.setValue(val);
		specialScope.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }

	}

	exAttrs.toCollection().removeAll(easToRemove);
    }

    // 解析XPDL文件保存到活动事件对象
    public void fromXML(Node node) {

	super.fromXML(node);

    }

    // 实现Clone方法
    public ActivityEventDevice clone() {
	ActivityEventDevice ae = (ActivityEventDevice) super.clone();

	ae.durationUnit = (XMLAttribute) this.durationUnit.clone();
	ae.alertTime = (XMLAttribute) this.alertTime.clone();
	ae.deadLineOperation = (XMLAttribute) this.deadLineOperation.clone();

	ae.canSpecialSend = (XMLAttribute) this.canSpecialSend.clone();
	ae.specialScope = (XMLAttribute) this.specialScope.clone();

	ae.fillStructure();
	return ae;
    }
}
