/* UserPropertyRefs.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.Iterator;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLListChoiceControlPanel;
import com.ds.bpm.bpd.xml.panels.XMLListChoicePanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * This is not a real WfMC DTD element, but it is introduced to help. This class
 * is a collection of class <b>UserPropertyRef</b> instances.
 * 
 * @see XML
 */
public class UserPropertyRefs extends XMLCollection {
	private transient UserProperties definedUserProperties = null;

	/**
	 * Creates a new instance of the class.
	 * 
	 * @param myPackage
	 *            The package within the properties are defined.
	 */
	public UserPropertyRefs(Package myPackage) {
		super(myPackage);

		if (myPackage != null) {
			this.definedUserProperties = myPackage
					.getUserDefinedActivityProperties();
		}
	}

	// min=0, max=unbounded
	/**
	 * Generates a new element of the class which instances are members of
	 * collection of this class. return The generated instance of class that
	 * makes collection.
	 */
	public XMLElement generateNewElement() {
		UserPropertyRef upr = new UserPropertyRef();
		upr.setRequired(true);
		return upr;
	}

	/**
	 * Creates panel which allows user to manipulate with instances of classes
	 * that makes a collection that this class represents. The panel consists of
	 * two sections: XMLListChoicePanel - shows collections' elements, and
	 * XMLListChoiceControlPanel - display buttons for manipulating with that
	 * elements.
	 * <p>
	 * NOTE: The order of creation is relevant, first, the controlled panel must
	 * be created, and then the control panel
	 * 
	 * @return DTDPanel to be shown
	 */
	public XMLPanel getPanel() {
		controlledPanel = new XMLListChoicePanel(this, "", XMLPanel.BOX_LAYOUT,
				true, false);
		controlPanel = new XMLListChoiceControlPanel(this,
				definedUserProperties, "", false, false);
		return new XMLGroupPanel(this, new XMLPanel[] { controlledPanel,
				controlPanel }, toLabel(), XMLPanel.BOX_LAYOUT, true, true);
	}

	/**
	 * Adds an user defined property to collection of properties for some
	 * activity. This is used when the new Activity is created by inserting it's
	 * visual object into the graph, to set all mandatory user properties
	 * defined, or when the new mandatory property is created.
	 * 
	 * @param up
	 *            The mandatory user property to add.
	 */
	public void addUserProperty(UserProperty up) {
		Iterator it = refCollectionElements.iterator();
		while (it.hasNext()) {
			if (((UserPropertyRef) it.next()).toValue() == up)
				return;
		}
		UserPropertyRef upr = new UserPropertyRef();
		upr.setValue(up);
		refCollectionElements.add(upr);
	}

	/**
	 * Removes an user defined property upon it's removal from collection of all
	 * defined properties for this package.
	 * 
	 * @param up
	 *            The user property to remove.
	 */
	public void removeUserProperty(UserProperty up) {
		Iterator it = refCollectionElements.iterator();
		UserPropertyRef toDelete = null;
		while (it.hasNext()) {
			UserPropertyRef upr = (UserPropertyRef) it.next();
			if (upr.toValue() == up) {
				toDelete = upr;
				break;
			}
		}
		if (toDelete != null) {
			refCollectionElements.remove(toDelete);
		}
	}

	/**
	 * Removes the prohibition of removal for specified property. This happens
	 * after the user changed properties type from <tt>MANDATORY</tt> or
	 * <tt>MANDATORYFROMNOWON</tt> to <tt>OPTIONAL</tt>.
	 * 
	 * @param up
	 *            The mandatory user property to remove prohibition of removal.
	 */
	public void refreshMandatories(UserProperty up) {
		Iterator it = refCollectionElements.iterator();
		while (it.hasNext()) {
			UserPropertyRef upr = (UserPropertyRef) it.next();
			if (upr.toValue() == up) {
				upr.setRequired(false);
			}
		}
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		UserPropertyRefs up = (UserPropertyRefs) super.clone();
		up.definedUserProperties = this.definedUserProperties;

		return up;
	}

}
