/* UserPropertyRef.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * This is not a real WfMC DTD element, but it is introduced to help.
 * 
 * @see XML
 */
public class UserPropertyRef extends XMLComplexElement {
	private XMLAttribute vValue = new XMLAttribute("Value");

	/**
	 * Creates a new instance of the class.
	 */
	public UserPropertyRef() {
		super();

		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		complexStructure.add(vValue);
	}

	/**
	 * Prepares panel to show editable fields of UserPropertyRef.
	 * 
	 * @return panel containing name, participant type and description fields
	 */
	public XMLPanel getPanel() {
		UserProperty up = (UserProperty) ((UserProperty) value).clone();
		up.setReadOnly(true);
		return new XMLGroupPanel(this, new Object[] { up.getPanel(0),
				up.getPanel(1), up.getPanel(2), up.getPanel(3), vValue },
				toLabel());
	}

	/**
	 * Overrides super-class method to implement this element specific value
	 * member setting. The value set to this element is an UserProperty object,
	 * and that's how this element holds a reference for on UserProperty.
	 * 
	 * @param o
	 *            The value to set.
	 */
	public void setValue(Object o) {
		super.setValue(o);
		if (o instanceof UserProperty) {
			vValue.setValue(((UserProperty) o).get("DefaultValue").toValue());
			if (!((UserProperty) o).isOptional()) {
				setRequired(true);
			} else {
				setRequired(false);
			}
		}
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		UserPropertyRef upr = (UserPropertyRef) super.clone();
		upr.vValue = (XMLAttribute) this.vValue.clone();
		upr.fillStructure();
		return upr;
	}

	/**
	 * Overrides super-class method to retreive the name of rererenced user
	 * defined property for activities.
	 * 
	 * @return The referenced user property.
	 */
	public String toString() {
		if (value != null) {
			return ((XMLElement) value).toString();
		} else {
			return "";
		}
	}
}
