/* TypeDeclaration.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.swing.JTextField;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLComplexChoice;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTextPanel;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class TypeDeclaration extends XMLCollectionElement {
	private DataTypes refType;

	private Description refDescription = new Description(); // min=0

	private ExtendedAttributes refExtendedAttributes = new ExtendedAttributes(
			this);

	private XMLAttribute attrName = new XMLAttribute("Name");

	/** Enables canceling of changes to the extended attributes collection. */
	private ExtendedAttributes clonedEAs;

	/**
	 * Creates a new instance of the class.
	 * 
	 * @param tds
	 *            The reference to collection of type declarations where this
	 *            instance will be put into.
	 */
	public TypeDeclaration(TypeDeclarations tds, Package p) {
		super(tds);

		refType = new DataTypes(this, p, null, 0);

		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		super.fillStructure();
		complexStructure.add(attrName);
		// attrName.setRequired(true);
		attributes.add(attrName);
		refType.setRequired(true);
		complexStructure.add(refType);
		complexStructure.add(refDescription);
		complexStructure.add(refExtendedAttributes);
	}

	public XMLPanel getPanel() {
		clonedEAs = (ExtendedAttributes) refExtendedAttributes.clone();
		return new XMLGroupPanel(this, new XMLElement[] { attrId, attrName,
				refType, refDescription, clonedEAs }, toLabel());
	}

	/**
	 * Overrides super-class method to retreive the value of this class "Name"
	 * attribute. This is used when displaying instance of this class within
	 * dialog.
	 * 
	 * @return The "Name" attribute value of this class.
	 */
	public String toString() {
		String disp = attrName.toString();
		if (disp.trim().length() == 0) {
			disp = attrId.toString().trim();
		}
		return disp;
	}

	/**
	 * Checks if an ID entered by the user is unique.
	 */
	public boolean isIDUniqueAndValid(XMLPanel groupPanel) {
		XMLTextPanel tp = (XMLTextPanel) ((XMLGroupPanel) groupPanel)
				.getPanel(0);
		String IDToCheck = tp.getText();
		// if there is an element with given ID, return false
		XMLComplexElement td = getCollection().getCollectionElement(IDToCheck);
		boolean isOK = true;
		String message = null;
		String dialogTitle = null;
		if (td != null && td != this) {
			message = XMLUtil.getLanguageDependentString("ErrorIDMustBeUnique");
			dialogTitle = XMLUtil.getLanguageDependentString("DialogIDIsNotUnique");
			isOK = false;
		} else if (!XMLCollection.isIdValid(IDToCheck)) {
			message = XMLUtil.getLanguageDependentString("ErrorIDMustBeValid");
			dialogTitle = XMLUtil.getLanguageDependentString("DialogIDIsNotValid");
			isOK = false;
		}
		if (!isOK) {
			XMLPanel.errorMessage(groupPanel.getDialog(), dialogTitle, "",
					message);
			((JTextField) tp.getComponent(2)).requestFocus();
		}
		return isOK;
	}

	/**
	 * Overrides parent method to display data type details for BasicType and
	 * for DeclaredType.
	 */
	public Collection toComplexTypeValues() {
		java.util.List l = new ArrayList();
		Iterator it = complexStructure.iterator();
		while (it.hasNext()) {
			XMLElement el = (XMLElement) it.next();
			if (el instanceof XMLAttribute) {
				l.add(el.toString());
			} else if (el instanceof DataTypes) {
				Object type = ((DataTypes) el).toValue();
				if (type instanceof BasicType) {
					l.add(el.toValue()
							+ " - "
							+ ((XMLAttribute) ((BasicType) type).get("Type"))
									.getChoosen());
				} else if (type instanceof DeclaredType) {
					l.add(el.toValue()
							+ " - "
							+ ((XMLComplexChoice) ((DeclaredType) type)
									.get("SubType")).getChoosen());
				} else {
					l.add(el.toValue());
				}
			} else {
				l.add(el.toValue());
			}
		}
		return l;
	}
	 public Package getPackage () {
	       return (Package)((TypeDeclarations)getCollection()).getOwner();
	    }
}
