/* TransitionRefs.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLElement;

/**
 * Represents a WfMC DTD element that has the similar name. This class is a
 * collection of class <b>TransitionRef</b> instances.
 */
public class TransitionRefs extends XMLCollection {
	public TransitionRefs() {
		super(null);
	}

	// min=0, max=unbounded
	/**
	 * Generates a new element of the class which instances are members of
	 * collection of this class. return The generated instance of class that
	 * makes collection.
	 */
	public XMLElement generateNewElement() {
		TransitionRef tr = new TransitionRef();
		tr.setRequired(true);
		return tr;
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		TransitionRefs t = (TransitionRefs) super.clone();
		return t;
	}

}
