/* StartMode.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLComplexChoice;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.panels.XMLComboPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

import org.w3c.dom.Node;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class StartMode extends XMLComplexElement {

	private boolean fromXMLExecuted = false;

	private XMLComplexChoice refMode = new XMLComplexChoice(name,
			new XMLElement[] { new Empty(), new Automatic(), new Manual() }, 1) {
		public XMLPanel getPanel() {
			return new XMLComboPanel(this);
		}
	};

	/**
	 * Creates a new instance of the class.
	 */
	public StartMode() {
		super();

		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		// refMode.setRequired(true);
		complexStructure.add(refMode);
	}

	public void fromXML(Node node) {
		fromXMLExecuted = true;
		refMode.setValue(refMode.getChoices()[0]);
		super.fromXML(node);
	}

	protected void afterImporting() {
		if (!fromXMLExecuted) {
			refMode.setValue(refMode.getChoices()[0]);
		}
	}

	/**
	 * The start mode is empty if user didn't select Automatic or Manual.
	 */
	public boolean isEmpty() {
		return (refMode.getChoosen() instanceof Empty);
	}

	/**
	 * Overrides the super class method to return the value of the choosen mode.
	 * 
	 * @return The value of choosen start mode.
	 */
	public Object toValue() {
		return refMode.toValue();
	}

	/**
	 * Overrides super-class method to retreive the choosen mode. This is used
	 * when displaying instance of this class within combo box.
	 * 
	 * @return The type of starting mode.
	 */
	public String toString() {
		return refMode.toString();
	}

	/**
	 * Prepares the panel with a combo box to choose the one of allowed start
	 * modes.
	 * 
	 * @return XMLPanel to be shown.
	 */
	public XMLPanel getPanel() {
		return refMode.getPanel();
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		StartMode sm = (StartMode) super.clone();

		sm.refMode = (XMLComplexChoice) this.refMode.clone();
		sm.fillStructure();

		return sm;
	}

}
